<?php
namespace PowerElements;
use PowerElements\Helpers\Partials as Partials;

use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Scheme_Typography;


	if ( ! defined( 'ABSPATH' ) ) {
		exit; // Exit if accessed directly.
	} 
	
	/**
	 * Power Element social widget.
	 *
	 * Elementor widget that displays a social with the ability to control every
	 * aspect of the social design.
	 *
	 * @since 1.0.0
	 */
	class PowerElements_Portfolio_Carousel extends Widget_Base {
		
		/**
		 * Get widget name.
		 *
		 * Retrieve social widget name.
		 *
		 * @since 1.0.0
		 * @access public
		 *
		 * @return string Widget name.
		 */
		public function get_name() {
			return 'power_elements_portfolio_carousel';
		}
		
		/**
		 * Get widget title.
		 *
		 * Retrieve social widget title.
		 *
		 * @since 1.0.0
		 * @access public
		 *
		 * @return string Widget title.
		 */
		public function get_title() {
			return esc_html__( 'Portfolio Carousel', 'power-elements' );
		}
		
		/**
		 * Get widget icon.
		 *
		 * Retrieve social widget icon.
		 *
		 * @since 1.0.0
		 * @access public
		 *
		 * @return string Widget icon.
		 */
		public function get_icon() {
			return 'eicon-posts-carousel';
		}
		
		/**
		 * Get widget categories.
		 *
		 * Retrieve the list of categories the social widget belongs to.
		 *
		 * Used to determine where to display the widget in the editor.
		 *
		 * @since 2.0.0
		 * @access public
		 *
		 * @return array Widget categories.
		 */
		public function get_categories() {
			return [ 'power-elements' ];
		}
		

		/**
		 * Register social widget controls.
		 *
		 * Adds different input fields to allow the user to change and customize the widget settings.
		 *
		 * @since 1.0.0
		 * @access protected
		 */
		protected function _register_controls() {
			$this->start_controls_section(
				'peeao_portfolio_carousel_section_content_tab',
				[
					'label' => __( 'Content', 'power-elements' ),
					'tab'   => Controls_Manager::TAB_CONTENT,
				]
			);
			$this->add_group_control(
				'powerpost',
				[
					'name' => 'powerpost',
				]
			);
			$this->add_control(
				'peeao_portfolio_carousel_advanced',
				[
					'label' => __( 'Advanced', 'power-elements' ),
					'type' => Controls_Manager::HEADING
				]
			);
			$this->add_control(
				'peeao_portfolio_carousel_orderby',
				[
					'label' => __( 'Order By', 'power-elements' ),
					'type' => Controls_Manager::SELECT,
					'default' => 'post_date',
					'options' => [
						'post_date' => __( 'Date', 'power-elements' ),
						'post_title' => __( 'Title', 'power-elements' ),
						'menu_order' => __( 'Menu Order', 'power-elements' ),
						'rand' => __( 'Random', 'power-elements' ),
					]
				]
			);
			
			$this->add_control(
				'peeao_portfolio_carousel_order',
				[
					'label' => __( 'Order', 'power-elements' ),
					'type' => Controls_Manager::SELECT,
					'default' => 'desc',
					'options' => [
						'asc' => __( 'ASC', 'power-elements' ),
						'desc' => __( 'DESC', 'power-elements' ),
					]
				]
			);
			
			$this->add_control(
				'peeao_portfolio_carousel_offset',
				[
					'label' => __( 'Offset', 'power-elements' ),
					'type' => Controls_Manager::NUMBER,
					'default' => 0,
					'description' => __( 'Use this setting to skip over posts (e.g. \'2\' to skip over 2 posts).', 'power-elements' ),
				]
			);
			$this->add_control(
				'peeao_portfolio_carousel_post__not_in',
				[
					'label' => __('Exclude', 'power-elements'),
					'type' => Controls_Manager::SELECT2,
					'options' => Partials::get_all_types_post(),
					'label_block' => true,
					'post_type' => '',
					'multiple' => true,
					'condition' => [
						'eaeposts_post_type!' => 'by_id',
					],
				]
			);
			$this->add_control(
				'peeao_portfolio_carousel_posts_per_page',
				[
					'label' => __('Posts Per Page', 'power-elements'),
					'type' => Controls_Manager::NUMBER,
					'default' => '4',
				]
			);
			$this->end_controls_section();

			/*
			 *
			 * SETTINGS
			 */
			$this->start_controls_section(
				'section_portfolio_carousel_settings',
				[
					'label' => __( 'Settings', 'power-elements' ),
					'tab'   => Controls_Manager::TAB_CONTENT,
				]
			);
			$this->add_control(
				'peeao_portfolio_carousel_item',
				[
					'label'       => __( 'Desktop Item', 'power-elements' ),
					'type'        => Controls_Manager::NUMBER,
					'min'         => 1,
					'max'         => 100,
					'step'        => 1,
					'default'     => 4,
					'description' => __( 'Number of item shows on destop and tablet screen', 'power-elements' ),
				]
			);
			$this->add_control(
				'peeao_portfolio_carousel_item_mobile',
				[
					'label'       => __( 'Mobile Item', 'power-elements' ),
					'type'        => Controls_Manager::NUMBER,
					'min'         => 1,
					'max'         => 100,
					'step'        => 1,
					'default'     => 1,
					'description' => __( 'Number of item shows on mobile and small tablet screen', 'power-elements' ),
				]
			);
			$this->add_control(
				'peeao_portfolio_carousel_margin',
				[
					'label'   => __( 'Margin', 'power-elements' ),
					'type'    => Controls_Manager::SLIDER,
					'range'   => [
						'min'  => 0,
						'max'  => 1000,
						'step' => 5,
					],
					'default' => [
						'size' => 30,
					],
				]
			);
			$this->add_control(
				'peeao_portfolio_carousel_padding',
				[
					'label'   => __( 'Padding', 'power-elements' ),
					'type'    => Controls_Manager::SLIDER,
					'range'   => [
						'min'  => 0,
						'max'  => 1000,
						'step' => 5,
					],
					'default' => [
						'size' => 30,
					],
				]
			);
			$this->add_control(
				'peeao_portfolio_carousel_autoplay',
				[
					'label'   => __( 'Autoplay', 'power-elements' ),
					'type'    => Controls_Manager::SELECT,
					'default' => 'false',
					'options' => [
						'true'  => __( 'True', 'power-elements' ),
						'false' => __( 'False', 'power-elements' ),
					],
				]
			);
			$this->add_control(
				'peeao_portfolio_carousel_responsive_class',
				[
					'label'   => __( 'Responsive Class', 'power-elements' ),
					'type'    => Controls_Manager::SELECT,
					'default' => 'false',
					'options' => [
						'true'  => __( 'True', 'power-elements' ),
						'false' => __( 'False', 'power-elements' ),
					],
				]
			);
			$this->add_control(
				'peeao_portfolio_carousel_dots',
				[
					'label'   => __( 'Dots', 'power-elements' ),
					'type'    => Controls_Manager::SELECT,
					'default' => 'false',
					'options' => [
						'true'  => __( 'True', 'power-elements' ),
						'false' => __( 'False', 'power-elements' ),
					],
				]
			);
			$this->add_control(
				'peeao_portfolio_carousel_nav',
				[
					'label'   => __( 'Navigation', 'power-elements' ),
					'type'    => Controls_Manager::SELECT,
					'default' => 'false',
					'options' => [
						'true'  => __( 'True', 'power-elements' ),
						'false' => __( 'False', 'power-elements' ),
					],
				]
			);
			$this->end_controls_section();

			$this->start_controls_section(
				'peeao_portfolio_carousel_section_posts_layout',
				[
					'label' => __( 'Layout', 'power-elements' ),
					'tab'   => Controls_Manager::TAB_CONTENT,
				]
			);

			$this->add_control(
				'peeao_portfolio_carousel_taxonomy',
				[
					'label' => __( 'Taxonomy', 'power-elements' ),
					'type' => Controls_Manager::SELECT,
					'options' => get_taxonomies(),
					'description' => __( 'Select taxonomy for relative post types. If not selected then category and filter not show.', 'power-elements' ),
				]
			);
			$this->add_control(
				'peeao_portfolio_carousel_show_popup',
				[
					'label' => __( 'Show Popup', 'power-elements' ),
					'type' => Controls_Manager::SWITCHER,
					'label_on' => __( 'Show', 'power-elements' ),
					'label_off' => __( 'Hide', 'power-elements' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);
			$this->add_control(
				'peeao_portfolio_carousel_icon',
				[
					'label' => esc_html__( 'Icon', 'power-elements' ),
					'type' => Controls_Manager::ICONS,
					'default' => [
						'value' => 'peeao peeao-ios-add',
						'library' => 'peeaoicons',
					],
					'condition'   => [
						'peeao_portfolio_carousel_show_popup' => 'yes',
					],
				]
			);
			$this->end_controls_section();
			$this->start_controls_section(
				'peeao_portfolio_carousel_section_filter_style',
				[
					'label' => __( 'Portfolio', 'power-elements' ),
					'tab'   => Controls_Manager::TAB_STYLE,
				]
			);
			$this->add_responsive_control(
				'peeao_portfolio_carousel_portfolio_margin',
				[
					'label'      => __( 'Margin', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .peeao-wrapper .power_portfoliocarousel_item .power_portfolio_thumb' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_portfolio_carousel_portfolio_padding',
				[
					'label'      => __( 'Padding', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .peeao-wrapper .power_portfoliocarousel_item .power_portfolio_thumb' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_control(
				'peeao_portfolio_carousel_portfolio_bg_color',
				[
					'label'     => __( 'Bg Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .peeao-wrapper .power_portfoliocarousel_item .power_portfolio_thumb' => 'background-color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name'     => 'peeao_portfolio_carousel_portfolio_wrapper_border',
					'label'    => __( 'Border', 'power-elements' ),
					'selector' => '{{WRAPPER}} .peeao-wrapper .power_portfoliocarousel_item .power_portfolio_thumb',
				]
			);
			$this->add_responsive_control(
				'peeao_portfolio_carousel_portfolio_wrapper_radius',
				[
					'label'      => __( 'Border Radius', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .peeao-wrapper .power_portfoliocarousel_item .power_portfolio_thumb' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_section();
			$this->start_controls_section(
				'peeao_portfolio_carousel_section_content_wrapper_style',
				[
					'label' => __( 'Content Wrapper', 'power-elements' ),
					'tab'   => Controls_Manager::TAB_STYLE,
				]
			);
			$this->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name' => 'peeao_portfolio_carousel_content_wrapper_background',
					'label' => __( 'Background', 'power-elements' ),
					'types' => [ 'gradient'],
					'selector' => '{{WRAPPER}} .peeao-wrapper .power_portfoliocarousel_item .power_portfolio_info',
				]
			);
			$this->end_controls_section();
			$this->start_controls_section(
				'peeao_portfolio_carousel_section_icon_style',
				[
					'label' => __( 'Icon', 'power-elements' ),
					'tab'   => Controls_Manager::TAB_STYLE,
				]
			);
			$this->add_control(
				'peeao_portfolio_carousel_icon_color',
				[
					'label'     => __( 'Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .peeao-wrapper .power_portfoliocarousel_item a.power_portfolio_popup' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_portfolio_carousel_icon_size',
				[
					'label' => __( 'Size', 'power-elements' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px'],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 50,
							'step' => 1,
						]
					],
					'default' => [
						'unit' => 'px',
						'size' => 42,
					],
					'selectors'  => [
						'{{WRAPPER}} .peeao-wrapper .power_portfoliocarousel_item a.power_portfolio_popup' => 'font-size: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_section();
			$this->start_controls_section(
				'peeao_portfolio_carousel_section_content_style',
				[
					'label' => __( 'Content', 'power-elements' ),
					'tab'   => Controls_Manager::TAB_STYLE,
				]
			);
			$this->add_control(
				'peeao_portfolio_carousel_content_options',
				[
					'label' => __( 'Info Wrapper', 'power-elements' ),
					'type' => Controls_Manager::HEADING,
					'separator' => 'before',
				]
			);
			$this->add_responsive_control(
				'peeao_portfolio_carousel_info_margin',
				[
					'label'      => __( 'Margin', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .peeao-wrapper .power_portfoliocarousel_item .power_portfolio_label_text' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_portfolio_carousel_info_padding',
				[
					'label'      => __( 'Padding', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .peeao-wrapper .power_portfoliocarousel_item .power_portfolio_label_text' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_control(
				'peeao_portfolio_carousel_info_bg_color',
				[
					'label'     => __( 'Bg Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .peeao-wrapper .power_portfoliocarousel_item .power_portfolio_label_text' => 'background-color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'peeao_portfolio_carousel_content_title_options',
				[
					'label' => __( 'Title', 'power-elements' ),
					'type' => Controls_Manager::HEADING,
					'separator' => 'before',
				]
			);
			$this->add_responsive_control(
				'peeao_portfolio_carousel_title_margin',
				[
					'label'      => __( 'Margin', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .peeao-wrapper .power_portfoliocarousel_item .power_portfolio_label_text .power_portfolio_item_title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_portfolio_carousel_title_padding',
				[
					'label'      => __( 'Padding', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .peeao-wrapper .power_portfoliocarousel_item .power_portfolio_label_text .power_portfolio_item_title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name'     => 'peeao_portfolio_carousel_title_typography',
					'label'    => __( 'Typography', 'power-elements' ),
					'scheme'   => Scheme_Typography::TYPOGRAPHY_1,
					'selector' => '{{WRAPPER}} .peeao-wrapper .power_portfoliocarousel_item .power_portfolio_label_text .power_portfolio_item_title',
				]
			);
			$this->add_control(
				'peeao_portfolio_carousel_title_color',
				[
					'label'     => __( 'Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .peeao-wrapper .power_portfoliocarousel_item .power_portfolio_label_text .power_portfolio_item_title a' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'peeao_portfolio_carousel_title_hover_color',
				[
					'label'     => __( 'Hover Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .peeao-wrapper .power_portfoliocarousel_item .power_portfolio_label_text .power_portfolio_item_title a:hover' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'peeao_portfolio_carousel_content_intro_options',
				[
					'label' => __( 'After Title', 'power-elements' ),
					'type' => Controls_Manager::HEADING,
					'separator' => 'before',
				]
			);
			$this->add_responsive_control(
				'peeao_portfolio_carousel_af_title_margin',
				[
					'label'      => __( 'Margin', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .peeao-wrapper .power_portfoliocarousel_item .power_portfolio_label_text .power_portfolio_item_tag' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_portfolio_carousel_af_title_padding',
				[
					'label'      => __( 'Padding', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .peeao-wrapper .power_portfoliocarousel_item .power_portfolio_label_text .power_portfolio_item_tag' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name'     => 'peeao_portfolio_carousel_af_title_typography',
					'label'    => __( 'Typography', 'power-elements' ),
					'scheme'   => Scheme_Typography::TYPOGRAPHY_1,
					'selector' => '{{WRAPPER}} .peeao-wrapper .power_portfoliocarousel_item .power_portfolio_label_text .power_portfolio_item_tag',
				]
			);
			$this->add_control(
				'peeao_portfolio_carousel_af_title_color',
				[
					'label'     => __( 'Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .peeao-wrapper .power_portfoliocarousel_item .power_portfolio_label_text .power_portfolio_item_tag' => 'color: {{VALUE}}',
					],
				]
			);
			$this->end_controls_section();


			/*
			 * STYLE NAVIGATION
			 */
			$this->start_controls_section(
				'peeao_portfoliocarousel_navigation_style',
				[
					'label' => __( 'Navigation', 'power-elements' ),
					'tab'   => Controls_Manager::TAB_STYLE,
				]
			);

			$this->start_controls_tabs(
				'peeao_portfoliocarousel_navigation_tab'
			);
			$this->start_controls_tab(
				'peeao_portfoliocarousel_navigation_normal_tab',
				[
					'label' => __( 'Normal', 'power-elements' ),
				]
			);
			$this->add_control(
				'peeao_portfoliocarousel_navigation_color',
				[
					'label'     => __( 'Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'default'   => '',
					'selectors' => [
						'{{WRAPPER}} .power_portfoliocarousel.owl-theme .owl-nav button.owl-prev, {{WRAPPER}} .power_portfoliocarousel.owl-theme .owl-nav button.owl-next'=> 'color: {{VALUE}}',
					]
				]
			);
			$this->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name'       => 'peeao_portfoliocarousel_navigation_background',
					'label'      => __( 'Background', 'power-elements' ),
					'types'      => [ 'classic', 'gradient' ],
					'show_label' => true,
					'selector'   => '{{WRAPPER}} .power_portfoliocarousel.owl-theme .owl-nav button.owl-prev, {{WRAPPER}} .power_portfoliocarousel.owl-theme .owl-nav button.owl-next',
				]
			);
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name'     => 'peeao_portfoliocarousel_navigation_border',
					'label'    => __( 'Border', 'power-elements' ),
					'selector'   => '{{WRAPPER}} .power_portfoliocarousel.owl-theme .owl-nav button.owl-prev, {{WRAPPER}} .power_portfoliocarousel.owl-theme .owl-nav button.owl-next',
				]
			);
			$this->add_responsive_control(
				'peeao_portfoliocarousel_navigation_border_radius',
				[
					'label'      => __( 'Border Radius', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_portfoliocarousel.owl-theme .owl-nav button.owl-prev, {{WRAPPER}} .power_portfoliocarousel.owl-theme .owl-nav button.owl-next' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_portfoliocarousel_navigation_width',
				[
					'label'   => __( 'Width', 'power-elements' ),
					'type'    => Controls_Manager::SLIDER,
					'size_units' => [ 'px' ],
					'range'   => [
						'min'  => 0,
						'max'  => 100,
						'step' => 2,
					],
					'default' => [
						'size' => 36,
					],
					'selectors'  => [
						'{{WRAPPER}} .power_portfoliocarousel.owl-theme .owl-nav button.owl-prev, {{WRAPPER}} .power_portfoliocarousel.owl-theme .owl-nav button.owl-next' => 'width: {{SIZE}}{{UNIT}}',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_portfoliocarousel_navigation_height',
				[
					'label'   => __( 'Height', 'power-elements' ),
					'type'    => Controls_Manager::SLIDER,
					'size_units' => [ 'px' ],
					'range'   => [
						'min'  => 0,
						'max'  => 100,
						'step' => 2,
					],
					'default' => [
						'size' => 36,
					],
					'selectors'  => [
						'{{WRAPPER}} .power_portfoliocarousel.owl-theme .owl-nav button.owl-prev, {{WRAPPER}} .power_portfoliocarousel.owl-theme .owl-nav button.owl-next' => 'height: {{SIZE}}{{UNIT}}',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_portfoliocarousel_navigation_margin',
				[
					'label'      => __( 'Margin', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_portfoliocarousel.owl-theme .owl-nav button.owl-prev, {{WRAPPER}} .power_portfoliocarousel.owl-theme .owl-nav button.owl-next' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_portfoliocarousel_navigation_padding',
				[
					'label'      => __( 'Padding', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_portfoliocarousel.owl-theme .owl-nav button.owl-prev, {{WRAPPER}} .power_portfoliocarousel.owl-theme .owl-nav button.owl-next' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Box_Shadow::get_type(),
				[
					'name'     => 'peeao_portfoliocarousel_navigation_box_shadow',
					'label'      => __( 'Box Shadow', 'power-elements' ),
					'selector' => '{{WRAPPER}} .power_portfoliocarousel.owl-theme .owl-nav button.owl-prev, {{WRAPPER}} .power_portfoliocarousel.owl-theme .owl-nav button.owl-next',
				]
			);

			$this->end_controls_tab();

			$this->start_controls_tab(
				'peeao_portfoliocarousel_navigation_hover_tab',
				[
					'label' => __( 'Hover', 'power-elements' ),
				]
			);
			$this->add_control(
				'peeao_portfoliocarousel_navigation_hover_color',
				[
					'label'     => __( 'Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'default'   => '',
					'selectors' => [
						'{{WRAPPER}} .power_portfoliocarousel.owl-theme .owl-nav button.owl-prev:hover, {{WRAPPER}} .power_portfoliocarousel.owl-theme .owl-nav button.owl-next:hover'=> 'color: {{VALUE}}',
					]
				]
			);
			$this->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name'       => 'peeao_portfoliocarousel_navigation_hover_background',
					'label'      => __( 'Background', 'power-elements' ),
					'types'      => [ 'classic', 'gradient' ],
					'show_label' => true,
					'selector'   => '{{WRAPPER}} .power_portfoliocarousel.owl-theme .owl-nav button.owl-prev:hover, {{WRAPPER}} .power_portfoliocarousel.owl-theme .owl-nav button.owl-next:hover',
				]
			);
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name'     => 'peeao_portfoliocarousel_navigation_hover_border',
					'label'    => __( 'Border', 'power-elements' ),
					'selector'   => '{{WRAPPER}} .power_portfoliocarousel.owl-theme .owl-nav button.owl-prev:hover, {{WRAPPER}} .power_portfoliocarousel.owl-theme .owl-nav button.owl-next:hover',
				]
			);
			$this->add_responsive_control(
				'peeao_portfoliocarousel_navigation_hover_border_radius',
				[
					'label'      => __( 'Border Radius', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_portfoliocarousel.owl-theme .owl-nav button.owl-prev:hover, {{WRAPPER}} .power_portfoliocarousel.owl-theme .owl-nav button.owl-next:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_tab();

			$this->end_controls_tabs();
			$this->end_controls_section();

			/*
			 * STYLE DOT
			 */
			$this->start_controls_section(
				'peeao_portfoliocarousel_dot_style',
				[
					'label' => __( 'Dot', 'power-elements' ),
					'tab'   => Controls_Manager::TAB_STYLE,
				]
			);

			$this->start_controls_tabs(
				'peeao_portfoliocarousel_dot_tab'
			);
			$this->start_controls_tab(
				'peeao_portfoliocarousel_dot_normal_tab',
				[
					'label' => __( 'Normal', 'power-elements' ),
				]
			);
			$this->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name'       => 'peeao_portfoliocarousel_dot_background',
					'label'      => __( 'Background', 'power-elements' ),
					'types'      => [ 'classic', 'gradient' ],
					'show_label' => true,
					'selector'   => '{{WRAPPER}} .power_portfoliocarousel.owl-theme .owl-dots .owl-dot',
				]
			);
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name'     => 'peeao_portfoliocarousel_dot_border',
					'label'    => __( 'Border', 'power-elements' ),
					'selector'   => '{{WRAPPER}} .power_portfoliocarousel.owl-theme .owl-dots .owl-dot',
				]
			);
			$this->add_responsive_control(
				'peeao_portfoliocarousel_dot_border_radius',
				[
					'label'      => __( 'Border Radius', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_portfoliocarousel.owl-theme .owl-dots .owl-dot' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_portfoliocarousel_dot_width',
				[
					'label'   => __( 'Width', 'power-elements' ),
					'type'    => Controls_Manager::SLIDER,
					'size_units' => [ 'px' ],
					'range'   => [
						'min'  => 0,
						'max'  => 30,
						'step' => 2,
					],
					'default' => [
						'size' => 18,
					],
					'selectors'  => [
						'{{WRAPPER}} .power_portfoliocarousel.owl-theme .owl-dots .owl-dot' => 'width: {{SIZE}}{{UNIT}}',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_portfoliocarousel_dot_height',
				[
					'label'   => __( 'Height', 'power-elements' ),
					'type'    => Controls_Manager::SLIDER,
					'size_units' => [ 'px' ],
					'range'   => [
						'min'  => 0,
						'max'  => 30,
						'step' => 2,
					],
					'default' => [
						'size' => 18,
					],
					'selectors'  => [
						'{{WRAPPER}} .power_portfoliocarousel.owl-theme .owl-dots .owl-dot' => 'height: {{SIZE}}{{UNIT}}',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_portfoliocarousel_dot_margin',
				[
					'label'      => __( 'Margin', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_portfoliocarousel.owl-theme .owl-dots .owl-dot' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_portfoliocarousel_dot_padding',
				[
					'label'      => __( 'Padding', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_portfoliocarousel.owl-theme .owl-dots .owl-dot' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Box_Shadow::get_type(),
				[
					'name'     => 'peeao_portfoliocarousel_dot_box_shadow',
					'label'      => __( 'Box Shadow', 'power-elements' ),
					'selector' => '{{WRAPPER}} .power_portfoliocarousel.owl-theme .owl-dots .owl-dot',
				]
			);

			$this->end_controls_tab();

			$this->start_controls_tab(
				'peeao_portfoliocarousel_dot_active_tab',
				[
					'label' => __( 'Active', 'power-elements' ),
				]
			);
			$this->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name'       => 'peeao_portfoliocarousel_dot_active_background',
					'label'      => __( 'Background', 'power-elements' ),
					'types'      => [ 'classic', 'gradient' ],
					'show_label' => true,
					'selector'   => '{{WRAPPER}} .power_portfoliocarousel.owl-theme .owl-dots .owl-dot.active',
				]
			);
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name'     => 'peeao_portfoliocarousel_dot_active_border',
					'label'    => __( 'Border', 'power-elements' ),
					'selector'   => '{{WRAPPER}} .power_portfoliocarousel.owl-theme .owl-dots .owl-dot.active',
				]
			);
			$this->add_responsive_control(
				'peeao_portfoliocarousel_dot_active_border_radius',
				[
					'label'      => __( 'Border Radius', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_portfoliocarousel.owl-theme .owl-dots .owl-dot.active' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_tab();
			
			$this->end_controls_tabs();
			$this->end_controls_section();
			
		}
		
		/**
		 * Render social widget output on the frontend.
		 *
		 * Written in PHP and used to generate the final HTML.
		 *
		 * @since 1.0.0
		 * @access protected
		 */
		protected function render() {
			$settings = $this->get_settings();
			//$settings = $this->get_settings();
			
			/**
			 * Setup the post arguments.
			 */
			
			$post_args              = Partials::get_post_settings( $settings );
			$query_args             = Partials::get_query_args( 'powerpost', $settings, 'portfolio_carousel');
			$query_args             = array_merge( $query_args, $post_args, $settings );
			
			if ( isset( $query_args['tax_query'] ) ) {
				$tax_query = $query_args['tax_query'];
			}
			/**
			 * Get posts from database.
			 */
			$posts = Partials::load_blog_posts( $query_args, 'portcarousel' );
			/**
			 * Set total posts.
			 */

			
			?>
			<div class="peeao-wrapper ">
				<div id="power-post-grid-<?php echo esc_attr( $this->get_id() ); ?>"
					class="power-post-grid-container">
					<div class="owl-carousel owl-theme power_portfoliocarousel"
						data-owl-carousel='{"items": <?php echo esc_attr($settings['peeao_portfolio_carousel_item'])?>, "margin": <?php echo esc_attr($settings['peeao_portfolio_carousel_margin']['size'])?>, "padding": <?php echo esc_attr($settings['peeao_portfolio_carousel_padding']['size'])?>, "autoplay": <?php echo esc_attr($settings['peeao_portfolio_carousel_autoplay'])?>, "responsiveClass": <?php echo esc_attr($settings['peeao_portfolio_carousel_responsive_class'])?>, "dots": <?php echo esc_attr($settings['peeao_portfolio_carousel_dots'])?>, "nav": <?php echo esc_attr($settings['peeao_portfolio_carousel_nav'])?>,"responsive":{ "0" :{ "items": <?php echo esc_attr($settings['peeao_portfolio_carousel_item_mobile'])?>}, "540" :{ "items": <?php echo esc_attr($settings['peeao_portfolio_carousel_item_mobile'])?> }, "860" :{ "items" : <?php echo esc_attr($settings['peeao_portfolio_carousel_item'])?> } , "1000":{ "items" : <?php echo esc_attr($settings['peeao_portfolio_carousel_item'])?> }}}'>
						<?php
							if ( ! empty( $posts['content'] ) ) {
								echo $posts['content'];
							} else {
								echo '<p class="text-danger">' . esc_html__( 'Something went wrong.', 'power-elements' ) . '</p>';
							}
						?>
					</div>
				</div>
			</div>
			<?php
		}
		
		/**
		 * Render social widget output in the editor.
		 *
		 * Written as a Backbone JavaScript template and used to generate the live preview.
		 *
		 * @since 1.0.0
		 * @access protected
		 */
		
		protected function _content_template() {}
	}