<?php
namespace PowerElements;
use PowerElements\Helpers\Partials as Partials;
use PowerElements\Helpers\Utils as Utils;

use \Elementor\Repeater;
use \Elementor\Icons_Manager;
use \Elementor\Widget_Base;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Scheme_Typography;
use \Elementor\Group_Control_Text_Shadow;




	if ( ! defined( 'ABSPATH' ) ) {
		exit; // Exit if accessed directly.
	}
	
	class PowerElements_Form extends Widget_Base {
		
		public function get_name() {
			return 'power_elements_form';
		}
		
		public function get_title() {
			return __( 'Form', 'power-elements' );
		}
		
		public function get_icon() {
			return 'eicon-button';
		}
		
		public function get_categories() {
			return [ 'power-elements' ];
		}
		
		protected function _register_controls() {
			$this->start_controls_section(
				'peeao_section_form_builder',
				[
					'label' => __( 'Form', 'power-elements' ),
				]
			);
			$this->add_control(
				'peeao_form_builder_id',
				[
					'label'   => __( 'Select Form', 'power-elements' ),
					'type'    => Controls_Manager::SELECT,
					'options' => Partials::get_all_forms(),
				]
			);
			$this->add_control(
				'peeao_form_builder_list_id', [
					'label' => esc_html__( 'List ID ', 'power-elements' ),
					'type' => Controls_Manager::TEXT,
					'default' => '',
				]
			);
			$this->end_controls_section();

			$this->start_controls_section(
				'peeao_section_form_builder_hidden_fields',
				[
					'label' => __( 'Hidden Fields', 'power-elements' ),
				]
			);
			$repeater = new Repeater();

			$repeater->add_control(
				'name', [
					'label' => esc_html__( 'Input Name : ', 'power-elements' ),
					'type' => Controls_Manager::TEXT,
					'default' => 'power_hidden_field_name',
				]
			);

			$repeater->add_control(
				'value', [
					'label' => esc_html__( 'Input Value', 'power-elements' ),
					'type' => Controls_Manager::TEXT,
					'default' => 'power_hidden_field_value',
				]
			);

			$repeater->add_control(
				'class',
				[
					'label' => esc_html__( 'Input Class', 'power-elements' ),
					'type' => Controls_Manager::TEXT,
					'default' => 'power_hidden_field_class',
				]
			);

			$this->add_control(
				'peeao_form_builder_hidden_field',
				[
					'label' => esc_html__( 'Input List', 'power-elements' ),
					'type' => Controls_Manager::REPEATER,
					'fields' => $repeater->get_controls(),
					'title_field' => '{{{ name }}}',
				]
			);
			$this->end_controls_section();

		}
		
		protected function render() {
			$settings = $this->get_settings();
			$unique_id = $this->get_name().'-'.$this->get_id();
			$hidden_fields = isset($settings['peeao_form_builder_hidden_field']) ? $settings['peeao_form_builder_hidden_field'] : ''; 
			
			$response = Libs\Integrations\MailChimp\Init::call_api($settings);
			?> 
			<div class="peeao-wrapper">
				<!-- <form id="power-form-<?php echo esc_attr($unique_id); ?>" 
					data-nonce="<?php echo wp_create_nonce('wp_rest');?>" 
					action="<?php echo esc_attr(get_rest_url()."power-form/v1/entries/insert/".$this->get_id()); ?>" 
					method="POST"
					data-form-id = "<?php echo esc_attr($this->get_id()); ?>"
					class="power-form-content" 
					enctype="multipart/form-data"> -->
				<form id="power-form-<?php echo esc_attr($unique_id); ?>" 
					data-nonce="<?php echo wp_create_nonce('wp_rest');?>" 
					action="" 
					method="POST"
					data-form-id = "<?php echo esc_attr($this->get_id()); ?>"
					class="power-form-content" 
					enctype="multipart/form-data">

					<?php if(!empty($hidden_fields)){
						foreach($hidden_fields as $input){
							echo "<input type='hidden' class=".esc_attr($input['class'])." name=".esc_attr($input['name'])." value=".esc_attr($input['value']).">";
						}
					} ?>
					<input type="hidden" id="form_nonce-<?php echo esc_attr($unique_id); ?>" name="form_nonce" value="<?php echo esc_attr(wp_create_nonce( 'form_nonce' )); ?>" />
					<?php echo Utils::get_builder_content($settings['peeao_form_builder_id']) ; ?>
				</form>
			</div>
			<?php 
		}
		
		protected function _content_template() { }
	}