<?php
namespace PowerElements;
use PowerElements\Helpers\Utils as Utils;


use \Elementor\Repeater;
use \Elementor\Icons_Manager;
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Scheme_Typography;
use \Elementor\Group_Control_Text_Shadow;


	if ( ! defined( 'ABSPATH' ) ) {
		exit; // Exit if accessed directly.
	}
	
	/**
	 * Power Element social widget.
	 *
	 * Elementor widget that displays a social with the ability to control every
	 * aspect of the social design.
	 *
	 * @since 1.0.0
	 */
	class PowerElements_Contact_Info extends Widget_Base {
		
		/**
		 * Get widget name.
		 *
		 * Retrieve social widget name.
		 *
		 * @since 1.0.0
		 * @access public
		 *
		 * @return string Widget name.
		 */
		public function get_name() {
			return 'power_elements_contact_info';
		}
		
		/**
		 * Get widget title.
		 *
		 * Retrieve social widget title.
		 *
		 * @since 1.0.0
		 * @access public
		 *
		 * @return string Widget title.
		 */
		public function get_title() {
			return __( 'Contact Info', 'power-elements' );
		}
		
		/**
		 * Get widget icon.
		 *
		 * Retrieve social widget icon.
		 *
		 * @since 1.0.0
		 * @access public
		 *
		 * @return string Widget icon.
		 */
		public function get_icon() {
			return 'eicon-text';
		}
		
		/**
		 * Get widget categories.
		 *
		 * Retrieve the list of categories the social widget belongs to.
		 *
		 * Used to determine where to display the widget in the editor.
		 *
		 * @since 2.0.0
		 * @access public
		 *
		 * @return array Widget categories.
		 */
		public function get_categories() {
			return [ 'power-elements' ];
		}

		
		/**
		 * Register social widget controls.
		 *
		 * Adds different input fields to allow the user to change and customize the widget settings.
		 *
		 * @since 1.0.0
		 * @access protected
		 */
		protected function _register_controls() {
			
			$this->start_controls_section(
				'peeao_contact_info_section_content',
				[
					'label' => __( 'Contact Info', 'power-elements' ),
					'tab'   => Controls_Manager::TAB_CONTENT,
				]
			);
			$this->add_responsive_control(
				'peeao_contact_info_flex_align',
				[
					'label'     => __( 'Alignment', 'power-elements' ),
					'type'      => Controls_Manager::CHOOSE,
					'options'   => [
						'flex-start'   => [
							'title' => __( 'Left', 'power-elements' ),
							'icon'  => 'fa fa-align-left',
						],
						'center' => [
							'title' => __( 'Center', 'power-elements' ),
							'icon'  => 'fa fa-align-center',
						],
						'flex-end'  => [
							'title' => __( 'Right', 'power-elements' ),
							'icon'  => 'fa fa-align-right',
						]
					],
					'default'   => 'center',
					'selectors' => [
						'{{WRAPPER}} .power_contact_info .power_contact_info_row' => 'justify-content: {{VALUE}};',
					]
				]
			);
			$this->add_control(
				'peeao_contact_info_style',
				[
					'label'        => __('Style', 'power-elements'),
					'type'         => Controls_Manager::SELECT,
					'default'      => 'regular',
					'options'      => [
						'regular'  => __('Regular', 'power-elements'),
						'inline'  => __('Inline', 'power-elements'),
					]
				]
			);
			$repeater = new Repeater();
			$repeater->add_control(
				'icon_image',
				[
					'label'        => __( 'Icon or Image', 'power-elements' ),
					'type'         => Controls_Manager::SWITCHER,
					'label_on'     => __( 'Icon', 'power-elements' ),
					'label_off'    => __( 'Image', 'power-elements' ),
					'return_value' => 'yes',
					'default'      => 'yes',
				]
			);
			 
			$repeater->add_control(
				'icon',
				[
					'label' => esc_html__( 'Icon', 'power-elements' ),
					'type' => Controls_Manager::ICONS,
					'default' => [
						'value' => 'peeao-md-pin',
						'library' => 'peeaoicons',
					],
					'condition'   => [
						'icon_image' => 'yes',
					],
				]
			);
			$repeater->add_control(
				'image',
				[
					'label'     => __( 'Choose Image', 'power-elements' ),
					'type'      => Controls_Manager::MEDIA,
					'default'   => [
						'url' => \Elementor\Utils::get_placeholder_image_src(),
					],
					'condition' => [
						'icon_image!' => 'yes',
					],
				]
			);
			$repeater->add_control(
				'title',
				[
					'label'       => __( 'Title', 'power-elements' ),
					'type'        => Controls_Manager::TEXT,
					'default'     => __( 'Address:', 'power-elements' ),
					'placeholder' => __( 'Type your title here', 'power-elements' ),
				]
			);
			$repeater->add_control(
				'description',
				[
					'label'       => __( 'Description', 'power-elements' ),
					'type'        => Controls_Manager::TEXTAREA,
					'rows'        => 10,
					'default'     => __( 'Default description', 'power-elements' ),
					'placeholder' => __( 'Type your description here', 'power-elements' ),
				]
			);
			$repeater->add_responsive_control(
				'peeao_contact_info_icon_padding',
				[
					'label'      => __( 'Padding', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} {{CURRENT_ITEM}} .power_contact_info_icon i' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$repeater->add_responsive_control(
				'peeao_contact_info_icon_size',
				[
					'label'     => __( 'Line Height', 'power-elements' ),
					'type'      => Controls_Manager::SLIDER,
					'default'   => [
						'size' => 48,
					],
					'range'     => [
						'px' => [
							'min' => 6,
						],
					],
					'selectors' => [
						'{{WRAPPER}} {{CURRENT_ITEM}} .power_contact_info_icon i'   => 'line-height: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->add_control(
				'peeao_contact_info_list',
				[
					'label'       => '',
					'type'        => Controls_Manager::REPEATER,
					'fields'      => $repeater->get_controls(),
					'default'     => [ 
						[
							'title' => __( 'Address: ', 'power-elements' ),
							'description' => __( '251, Casanova St. Utas,United States of America ', 'power-elements' ),
						],
						[
							'title' => __( 'Phone: ', 'power-elements' ),
							'description' => __( '+7 123 456-58-83,  +7 89 121-58-61 ', 'power-elements' ),
						],
						[
							'title' => __( 'E-Mails:', 'power-elements' ),
							'description' => __( 'support@powerelements.com', 'power-elements' ),
						],
					],
					'title_field' => '{{{ title }}}',
				]
			);

			$this->end_controls_section();
			/*
			 * STYLE OPTIONS
			 */
			$this->start_controls_section(
				'peeao_contact_info_section_style',
				[
					'label' => __( 'Contact Info Box', 'power-elements' ),
					'tab'   => Controls_Manager::TAB_STYLE,
				]
			);
			$this->start_controls_tabs(
				'peeao_contact_info_tabs'
			);
			
			$this->start_controls_tab(
				'peeao_contact_info_normal_tab',
				[
					'label' => __( 'Normal', 'power-elements' ),
				]
			);
			$this->add_control(
				'peeao_contact_info_bg_color',
				[
					'label'     => __( 'Background Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_contact_info' => 'background-color: {{VALUE}}',
					],
				]
			);			
			$this->add_group_control(
				Group_Control_Box_Shadow::get_type(),
				[
					'name' => 'peeao_contact_info_shadow',
					'label' => __( 'Box Shadow', 'power-elements' ),
					'selector' => '{{WRAPPER}} .power_contact_info',
				]
			);
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name'     => 'peeao_contact_info_border',
					'label'    => __( 'Border', 'power-elements' ),
					'selector' => '{{WRAPPER}} .power_contact_info',
				]
			);
			$this->add_responsive_control(
				'peeao_contact_info_radius',
				[
					'label'      => __( 'Border Radius', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_contact_info' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_contact_info_padding',
				[
					'label'      => __( 'Padding', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_contact_info' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_contact_info_margin',
				[
					'label'      => __( 'Margin', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_contact_info' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_tab();
			/*
			 * HOVER
			 */
			$this->start_controls_tab(
				'peeao_contact_info_hover_tab',
				[
					'label' => __( 'Hover', 'power-elements' ),
				]
			);
			$this->add_control(
				'peeao_contact_info_bg_color_hover',
				[
					'label'     => __( 'Background Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_contact_info:hover' => 'background-color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Box_Shadow::get_type(),
				[
					'name' => 'peeao_contact_info_shadow_hover',
					'label' => __( 'Box Shadow', 'power-elements' ),
					'selector' => '{{WRAPPER}} .power_contact_info:hover',
				]
			);
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name'     => 'peeao_contact_info_border_hover',
					'label'    => __( 'Border', 'power-elements' ),
					'selector' => '{{WRAPPER}} .power_contact_info:hover',
				]
			);
			$this->add_responsive_control(
				'peeao_contact_info_radius_hover',
				[
					'label'      => __( 'Border Radius', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_contact_info:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_contact_info_padding_hover',
				[
					'label'      => __( 'Padding', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_contact_info:hover' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_contact_info_margin_hover',
				[
					'label'      => __( 'Margin', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_contact_info:hover' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_tab();
			$this->end_controls_tabs();
			$this->end_controls_section();

			/*
			 * STYLE OPTIONS WRAPPER
			 */
			$this->start_controls_section(
				'peeao_contact_info_section_wrapper_style',
				[
					'label' => __( 'Contact Info Item', 'power-elements' ),
					'tab'   => Controls_Manager::TAB_STYLE,
				]
			);
			$this->start_controls_tabs(
				'peeao_contact_info_wrapper_tabs'
			);
			
			$this->start_controls_tab(
				'peeao_contact_info_wrapper_normal_tab',
				[
					'label' => __( 'Normal', 'power-elements' ),
				]
			);
			$this->add_control(
				'peeao_contact_info_wrapper_bg_color',
				[
					'label'     => __( 'Background Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_contact_info .power_contact_info_row' => 'background-color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name'     => 'peeao_contact_info_wrapper_border',
					'label'    => __( 'Border', 'power-elements' ),
					'selector' => '{{WRAPPER}} .power_contact_info .power_contact_info_row',
				]
			);
			$this->add_responsive_control(
				'peeao_contact_info_wrapper_radius',
				[
					'label'      => __( 'Border Radius', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_contact_info .power_contact_info_row' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Box_Shadow::get_type(),
				[
					'name' => 'peeao_contact_info_wrapper_shadow',
					'label' => __( 'Box Shadow', 'power-elements' ),
					'selector' => '{{WRAPPER}} .power_contact_info .power_contact_info_row',
				]
			);
			$this->add_responsive_control(
				'peeao_contact_info_wrapper_padding',
				[
					'label'      => __( 'Padding', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_contact_info .power_contact_info_row' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_contact_info_wrapper_margin',
				[
					'label'      => __( 'Margin', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_contact_info .power_contact_info_row' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_tab();
			/*
			 * HOVER
			 */
			$this->start_controls_tab(
				'peeao_contact_info_wrapper_hover_tab',
				[
					'label' => __( 'Hover', 'power-elements' ),
				]
			);
			$this->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name' => 'peeao_contact_info_wrapper_bg_color_hover',
					'label' => __( 'Background', 'power-elements' ),
					'types' => [ 'gradient'],
					'selector' => '{{WRAPPER}} .power_contact_info:hover .power_contact_info_row',
				]
			);
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name'     => 'peeao_contact_info_wrapper_border_hover',
					'label'    => __( 'Border', 'power-elements' ),
					'selector' => '{{WRAPPER}} .power_contact_info:hover .power_contact_info_row',
				]
			);
			$this->add_responsive_control(
				'peeao_contact_info_wrapper_radius_hover',
				[
					'label'      => __( 'Border Radius', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_contact_info:hover .power_contact_info_row' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_contact_info_wrapper_padding_hover',
				[
					'label'      => __( 'Padding', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_contact_info:hover .power_contact_info_row' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_contact_info_wrapper_margin_hover',
				[
					'label'      => __( 'Margin', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_contact_info:hover .power_contact_info_row' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_tab();
			$this->end_controls_tabs();
			$this->end_controls_section();
			/*
			 * STYLE OPTIONS ICON
			 */
			$this->start_controls_section(
				'peeao_contact_info_section_icon_style',
				[
					'label' => __( 'Icon', 'power-elements' ),
					'tab'   => Controls_Manager::TAB_STYLE,
				]
			);
			$this->start_controls_tabs(
				'peeao_contact_info_icon_tabs'
			);
			$this->start_controls_tab(
				'peeao_contact_info_icon_normal_tab',
				[
					'label' => __( 'Normal', 'power-elements' ),
				]
			);
			$this->add_control(
				'peeao_contact_info_icon_color',
				[
					'label'     => __( 'Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'default'   => '',
					'selectors' => [
						'{{WRAPPER}} .power_contact_info .power_contact_info_icon' => 'color: {{VALUE}};',
					]
				]
			);
			$this->add_responsive_control(
				'peeao_contact_info_icon_size',
				[
					'label'     => __( 'Size', 'power-elements' ),
					'type'      => Controls_Manager::SLIDER,
					'default'   => [
						'size' => 36,
					],
					'range'     => [
						'px' => [
							'min' => 6,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .power_contact_info .power_contact_info_icon'   => 'font-size: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->add_control(
				'peeao_contact_info_icon_bg_color',
				[
					'label'     => __( 'Background Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .power_contact_info .power_contact_info_icon' => 'background-color: {{VALUE}}',
					],
				]
			);			
			$this->add_group_control(
				Group_Control_Box_Shadow::get_type(),
				[
					'name' => 'peeao_contact_info_icon_shadow',
					'label' => __( 'Box Shadow', 'power-elements' ),
					'selector' => '{{WRAPPER}} .power_contact_info .power_contact_info_icon',
				]
			);
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name'     => 'peeao_contact_info_icon_border',
					'label'    => __( 'Border', 'power-elements' ),
					'selector' => '{{WRAPPER}} .power_contact_info .power_contact_info_icon',
				]
			);
			$this->add_responsive_control(
				'peeao_contact_info_icon_radius',
				[
					'label'      => __( 'Border Radius', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_contact_info .power_contact_info_icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_contact_info_icon_margin',
				[
					'label'      => __( 'Margin', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_contact_info .power_contact_info_icon' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_tab();
			/*
			 * HOVER
			 */
			$this->start_controls_tab(
				'peeao_contact_info_icon_hover_tab',
				[
					'label' => __( 'Hover', 'power-elements' ),
				]
			);
			$this->add_control(
				'peeao_contact_info_icon_hover_color',
				[
					'label'     => __( 'Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'default'   => '',
					'selectors' => [
						'{{WRAPPER}} .power_contact_info:hover .power_contact_info_icon' => 'color: {{VALUE}};',
					]
				]
			);
			$this->end_controls_tab();
			$this->end_controls_tabs();
			$this->end_controls_section();

			
			$this->end_controls_tabs();
			$this->end_controls_section();

			/*
			 * STYLE OPTIONS TITLE
			 */
			$this->start_controls_section(
				'peeao_contact_info_section_title_style',
				[
					'label' => __( 'Title', 'power-elements' ),
					'tab'   => Controls_Manager::TAB_STYLE,
				]
			);
			$this->start_controls_tabs(
				'peeao_contact_info_title_tabs'
			);
			$this->start_controls_tab(
				'peeao_contact_info_title_normal_tab',
				[
					'label' => __( 'Normal', 'power-elements' ),
				]
			);
			$this->add_control(
				'peeao_contact_info_title_color',
				[
					'label'     => __( 'Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'default'   => '',
					'selectors' => [
						'{{WRAPPER}} .power_contact_info .power_contact_info_row h4' => 'color: {{VALUE}};',
					]
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name'     => 'peeao_contact_info_title_typography',
					'label'    => __( 'Typography', 'power-elements' ),
					'fields_options' => [
						'font_weight' => [
							'default' => '500',
						],
						'font_family' => [
							'default' => 'Poppins',
						],
						'font_size'   => [
							[ 'default' => [ 'unit' => 'px', 'size' => 11 ] ]
						],
						'text_transform' => [
							'default' => 'uppercase'
						]
					],
					'selector' => '{{WRAPPER}} .power_contact_info .power_contact_info_row h4',
				]
			);
			$this->add_group_control(
				Group_Control_Text_Shadow::get_type(),
				[
					'name'     => 'peeao_contact_info_title_text_shadow',
					'label'    => __( 'Text Shadow', 'power-elements' ),
					'selector' => '{{WRAPPER}} .power_contact_info .power_contact_info_row h4',
				]
			);
			$this->add_responsive_control(
				'peeao_contact_info_title_margin',
				[
					'label'      => __( 'Margin', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_contact_info .power_contact_info_row h4' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_contact_info_title_padding',
				[
					'label'      => __( 'Padding', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_contact_info .power_contact_info_row h4' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_tab();
			/*
			 * HOVER
			 */
			$this->start_controls_tab(
				'peeao_contact_info_title_hover_tab',
				[
					'label' => __( 'Hover', 'power-elements' ),
				]
			);
			$this->add_control(
				'peeao_contact_info_title_hover_color',
				[
					'label'     => __( 'Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'default'   => '',
					'selectors' => [
						'{{WRAPPER}} .power_contact_info:hover .power_contact_info_row h4' => 'color: {{VALUE}};',
					]
				]
			);
			$this->end_controls_tab();
			$this->end_controls_tabs();
			$this->end_controls_section();
			/*
			 * STYLE OPTIONS DESCRIPTION
			 */
			$this->start_controls_section(
				'peeao_contact_info_section_des_style',
				[
					'label' => __( 'Description', 'power-elements' ),
					'tab'   => Controls_Manager::TAB_STYLE,
				]
			);
			$this->start_controls_tabs(
				'peeao_contact_info_des_tabs'
			);
			$this->start_controls_tab(
				'peeao_contact_info_des_normal_tab',
				[
					'label' => __( 'Normal', 'power-elements' ),
				]
			);
			$this->add_control(
				'peeao_contact_info_des_color',
				[
					'label'     => __( 'Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'default'   => '',
					'selectors' => [
						'{{WRAPPER}} .power_contact_info .power_contact_info_row p' => 'color: {{VALUE}};',
					]
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name'     => 'peeao_contact_info_des_typography',
					'label'    => __( 'Typography', 'power-elements' ),
					'scheme'   => Scheme_Typography::TYPOGRAPHY_1,
					'selector' => '{{WRAPPER}} .power_contact_info .power_contact_info_row p',
				]
			);
			$this->add_group_control(
				Group_Control_Text_Shadow::get_type(),
				[
					'name'     => 'peeao_contact_info_des_text_shadow',
					'label'    => __( 'Text Shadow', 'power-elements' ),
					'selector' => '{{WRAPPER}} .power_contact_info .power_contact_info_row p',
				]
			);
			$this->add_responsive_control(
				'peeao_contact_info_des_margin',
				[
					'label'      => __( 'Margin', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_contact_info .power_contact_info_row p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_contact_info_des_padding',
				[
					'label'      => __( 'Padding', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .power_contact_info .power_contact_info_row p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_tab();
			/*
			 * HOVER
			 */
			$this->start_controls_tab(
				'peeao_contact_info_des_hover_tab',
				[
					'label' => __( 'Hover', 'power-elements' ),
				]
			);
			$this->add_control(
				'peeao_contact_info_des_hover_color',
				[
					'label'     => __( 'Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'default'   => '',
					'selectors' => [
						'{{WRAPPER}} .power_contact_info:hover .power_contact_info_row p' => 'color: {{VALUE}};',
					]
				]
			);
			$this->end_controls_tab();
			$this->end_controls_tabs();
			$this->end_controls_section();
		}
		
		
		/**
		 * Render social widget output on the frontend.
		 *
		 * Written in PHP and used to generate the final HTML.
		 *
		 * @since 1.0.0
		 * @access protected
		 */
		protected function render() {
			$settings = $this->get_settings();
			extract($settings); ?>

				<div class="peeao-wrapper">
					<div class="power_contact_info">
						<?php foreach ( $peeao_contact_info_list as $item ) { ?>
							<div class="power_contact_info_row elementor-repeater-item-<?php echo $item['_id']; ?>">
								<?php if($item['icon_image'] == 'yes'){
									if($item['icon']['value'] != ''){ ?>
										<div class="power_contact_info_icon">
											<?php Icons_Manager::render_icon( $item['icon']); ?>
										</div>
									<?php }
								}else{ ?>
									<div class="power_contact_info_icon">
										<img src="<?php echo  esc_url( $item['image']['url'] ); ?>'" alt="<?php echo  esc_attr( $item['title'] ); ?>">
									</div>
								<?php } ?>
								<div class="power_contact_info_inner power_contact_info_style_<?php echo $peeao_contact_info_style; ?>">
									<h4><?php echo Utils::kses( $item['title'] ) ; ?></h4>
									<p><?php echo Utils::kses( $item['description'] ) ; ?></p>
								</div>
							</div>
						<?php } ?>
					</div>
				</div>

			<?php 
			
		}
		
		/**
		 * Render social widget output in the editor.
		 *
		 * Written as a Backbone JavaScript template and used to generate the live preview.
		 *
		 * @since 1.0.0
		 * @access protected
		 */
		protected function _content_template() { }
		
	}