<?php

namespace PowerElements;

use PowerElements\Helpers\Partials as Partials;

use \Elementor\Widget_Base;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Scheme_Typography;
use \Elementor\Group_Control_Text_Shadow;

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly.
}

/**
 * Power Element social widget.
 *
 * Elementor widget that displays a social with the ability to control every
 * aspect of the social design.
 *
 * @since 1.0.0
 */
class PowerElements_Blog_Posts extends Widget_Base
{

	/**
	 * Get widget name.
	 *
	 * Retrieve social widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name()
	{
		return 'power_elements_blog_posts';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve social widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title()
	{
		return __('Blog Posts', 'power-elements');
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve social widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon()
	{
		return 'eicon-posts-grid';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the social widget belongs to.
	 *
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since 2.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories()
	{
		return ['power-elements'];
	}

	/**
	 * Register social widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function _register_controls()
	{
		$this->start_controls_section(
			'peeao_blog_section_posts_content',
			[
				'label' => __('Content', 'power-elements'),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_group_control(
			'powerpost',
			[
				'name' => 'powerpost',
			]
		);
		$this->add_control(
			'peeao_blog_advanced',
			[
				'label' => __('Advanced', 'power-elements'),
				'type'  => Controls_Manager::HEADING
			]
		);
		$this->add_control(
			'peeao_blog_orderby',
			[
				'label'   => __('Order By', 'power-elements'),
				'type'    => Controls_Manager::SELECT,
				'default' => 'post_date',
				'options' => [
					'post_date'  => __('Date', 'power-elements'),
					'post_title' => __('Title', 'power-elements'),
					'menu_order' => __('Menu Order', 'power-elements'),
					'rand'       => __('Random', 'power-elements'),
				]
			]
		);

		$this->add_control(
			'peeao_blog_order',
			[
				'label'   => __('Order', 'power-elements'),
				'type'    => Controls_Manager::SELECT,
				'default' => 'desc',
				'options' => [
					'asc'  => __('ASC', 'power-elements'),
					'desc' => __('DESC', 'power-elements'),
				]
			]
		);

		$this->add_control(
			'peeao_blog_offset',
			[
				'label'       => __('Offset', 'power-elements'),
				'type'        => Controls_Manager::NUMBER,
				'default'     => 0,
				'description' => __('Use this setting to skip over posts (e.g. \'2\' to skip over 2 posts).', 'power-elements'),
			]
		);
		$this->add_control(
			'peeao_blog_post__not_in',
			[
				'label'       => __('Exclude', 'power-elements'),
				'type'        => Controls_Manager::SELECT2,
				'options'     => Partials::get_all_types_post(),
				'label_block' => true,
				'post_type'   => '',
				'multiple'    => true,
			]
		);
		$this->add_control(
			'peeao_blog_posts_per_page',
			[
				'label'   => __('Posts Per Page', 'power-elements'),
				'type'    => Controls_Manager::NUMBER,
				'default' => '3',
			]
		);
		$this->end_controls_section();
		/*
			 *
			 * SETTINGS
			 */
		$this->start_controls_section(
			'peeao_blog_section_settings',
			[
				'label' => __('Settings', 'power-elements'),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'peeao_blog_grid_item',
			[
				'label'   => __('Grid Item', 'power-elements'),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					'12'  => __('1', 'power-elements'),
					'6'   => __('2', 'power-elements'),
					'4'   => __('3', 'power-elements'),
					'3'   => __('4', 'power-elements'),
					'2'   => __('6', 'power-elements'),
				],
				'default' => '4'
			]
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'peeao_blog_post_layout_style',
			[
				'label' => __('Layout', 'power-elements'),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'peeao_blog_show_image',
			[
				'label'   => __('Show Image', 'power-elements'),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'1' => [
						'title' => __('Yes', 'power-elements'),
						'icon'  => 'fa fa-check',
					],
					'0' => [
						'title' => __('No', 'power-elements'),
						'icon'  => 'fa fa-ban',
					],
				],
				'default' => '1',
			]
		);
		$this->add_group_control(
			Group_Control_Image_Size::get_type(),
			[
				'name'      => 'peeao_blog_image',
				'exclude'   => ['custom'],
				'default'   => 'medium',
				'condition' => [
					'peeao_blog_show_image' => '1',
				],
			]
		);
		$this->add_control(
			'peeao_blog_show_title',
			[
				'label'   => __('Show Title', 'power-elements'),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'1' => [
						'title' => __('Yes', 'power-elements'),
						'icon'  => 'fa fa-check',
					],
					'0' => [
						'title' => __('No', 'power-elements'),
						'icon'  => 'fa fa-ban',
					],
				],
				'default' => '1',
			]
		);

		$this->add_control(
			'peeao_blog_show_excerpt',
			[
				'label'   => __('Show excerpt', 'power-elements'),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'1' => [
						'title' => __('Yes', 'power-elements'),
						'icon'  => 'fa fa-check',
					],
					'0' => [
						'title' => __('No', 'power-elements'),
						'icon'  => 'fa fa-ban',
					],
				],
				'default' => '1',
			]
		);

		$this->add_control(
			'peeao_blog_excerpt_length',
			[
				'label'     => __('Excerpt Words', 'power-elements'),
				'type'      => Controls_Manager::NUMBER,
				'default'   => '10',
				'condition' => [
					'peeao_blog_show_excerpt' => '1',
				],
			]
		);
		$this->add_control(
			'peeao_blog_show_read_more',
			[
				'label'   => __('Show Read More', 'power-elements'),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'1' => [
						'title' => __('Yes', 'power-elements'),
						'icon'  => 'fa fa-check',
					],
					'0' => [
						'title' => __('No', 'power-elements'),
						'icon'  => 'fa fa-ban',
					],
				],
				'default' => '0'
			]
		);
		$this->add_control(
			'peeao_blog_read_more_position',
			[
				'label'   => __('Read More Position', 'power-elements'),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					'1'  => __('With meta', 'power-elements'),
					'2' => __('After meta', 'power-elements'),
				],
				'condition'   => [
					'peeao_blog_show_read_more' => '1',
				],
				'default' => '2'
			]
		);

		$this->add_control(
			'peeao_blog_read_more_text',
			[
				'label'       => esc_html__('Label Text', 'power-elements'),
				'type'        => Controls_Manager::TEXT,
				'label_block' => false,
				'default'     => esc_html__('Read More', 'power-elements'),
				'condition'   => [
					'peeao_blog_show_read_more' => '1',
				],
			]
		);
		$this->add_control(
			'peeao_blog_show_category',
			[
				'label'   => __('Show Category', 'power-elements'),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'1' => [
						'title' => __('Yes', 'power-elements'),
						'icon'  => 'fa fa-check',
					],
					'0' => [
						'title' => __('No', 'power-elements'),
						'icon'  => 'fa fa-ban',
					],
				],
				'default' => '1',
			]
		);
		$this->add_control(
			'peeao_blog_category_text',
			[
				'label'       => esc_html__('Label Text', 'power-elements'),
				'type'        => Controls_Manager::TEXT,
				'label_block' => false,
				'default'     => esc_html__('Categories:', 'power-elements'),
				'condition'   => [
					'peeao_blog_show_category' => '1',
				],
			]
		);
		$this->add_control(
			'peeao_blog_category_position',
			[
				'label'   => __('Category Position', 'power-elements'),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					'1'  => __('With Meta ', 'power-elements'),
					'2' => __('Without Meta', 'power-elements'),
				],
				'condition'   => [
					'peeao_blog_show_category' => '1',
				],
				'default' => '2'
			]
		);
		$this->add_control(
			'peeao_blog_show_meta',
			[
				'label'   => __('Show Meta', 'power-elements'),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'1' => [
						'title' => __('Yes', 'power-elements'),
						'icon'  => 'fa fa-check',
					],
					'0' => [
						'title' => __('No', 'power-elements'),
						'icon'  => 'fa fa-ban',
					],
				],
				'default' => '1',
			]
		);
		$this->add_control(
			'peeao_blog_meta_position',
			[
				'label'   => __('Meta Position', 'power-elements'),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					'1'  => __('Before Title ', 'power-elements'),
					'2' => __('After Title', 'power-elements'),
					'3' => __('After Content', 'power-elements'),
				],
				'condition'   => [
					'peeao_blog_show_meta' => '1',
				],
				'default' => '3'
			]
		);
		$this->add_control(
			'peeao_blog_show_author',
			[
				'label'   => __('Show Author', 'power-elements'),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'1' => [
						'title' => __('Yes', 'power-elements'),
						'icon'  => 'fa fa-check',
					],
					'0' => [
						'title' => __('No', 'power-elements'),
						'icon'  => 'fa fa-ban',
					],
				],
				'condition'   => [
					'peeao_blog_show_meta' => '1',
				],
				'default' => '0',
			]
		);
		$this->add_control(
			'peeao_blog_show_avatar',
			[
				'label'   => __('Show Avatar', 'power-elements'),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'1' => [
						'title' => __('Yes', 'power-elements'),
						'icon'  => 'fa fa-check',
					],
					'0' => [
						'title' => __('No', 'power-elements'),
						'icon'  => 'fa fa-ban',
					],
				],
				'condition'   => [
					'peeao_blog_show_meta' => '1',
					'peeao_blog_show_author' => '1',
				],
				'default' => '0',
			]
		);
		$this->add_control(
			'peeao_blog_show_date',
			[
				'label'   => __('Show Date', 'power-elements'),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'1' => [
						'title' => __('Yes', 'power-elements'),
						'icon'  => 'fa fa-check',
					],
					'0' => [
						'title' => __('No', 'power-elements'),
						'icon'  => 'fa fa-ban',
					],
				],
				'condition'   => [
					'peeao_blog_show_meta' => '1',
				],
				'default' => '1',
			]
		);
		$this->add_control(
			'peeao_blog_show_date_style',
			[
				'label'   => __('Date Style', 'power-elements'),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					'1'  => __('Normal ', 'power-elements'),
					'2' => __('Advanced', 'power-elements'),
				],
				'condition'   => [
					'peeao_blog_show_date' => '1',
					'peeao_blog_meta_position' => '1',
					'peeao_blog_show_author' => '0',
					'peeao_blog_show_category' => '0',
				],
				'default' => '1'
			]
		);
		$this->add_control(
			'peeao_blog_date_icon',
			[
				'label' => esc_html__('Date Icon', 'power-elements'),
				'type' => Controls_Manager::ICONS,
				'condition'   => [
					'peeao_blog_show_date' => '1',
					'peeao_blog_show_date_style' => '1',
				],
			]
		);
		$this->add_control(
			'peeao_blog_show_comments',
			[
				'label'   => __('Show Comments', 'power-elements'),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'1' => [
						'title' => __('Yes', 'power-elements'),
						'icon'  => 'fa fa-check',
					],
					'0' => [
						'title' => __('No', 'power-elements'),
						'icon'  => 'fa fa-ban',
					],
				],
				'condition'   => [
					'peeao_blog_show_meta' => '1',
				],
				'default' => '1',
			]
		);
		$this->add_control(
			'peeao_blog_comment_icon',
			[
				'label' => esc_html__('Comment Icon', 'power-elements'),
				'type' => Controls_Manager::ICONS,
				'condition'   => [
					'peeao_blog_show_comments' => '1',
				],
			]
		);

		$this->end_controls_section();


		/*
		* Item Style
		*/
		$this->start_controls_section(
			'peeao_blog_item_style',
			[
				'label' => __('Item Wrapper', 'power-elements'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'peeao_blog_item_wrapper_bg_color',
			[
				'label'     => __('Background Color', 'power-elements'),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .power_blog_post' => 'background-color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'     => 'peeao_blog_item_wrapper_border',
				'label'    => __('Border', 'power-elements'),
				'selector' => '{{WRAPPER}} .power_blog_post',
			]
		);
		$this->add_responsive_control(
			'peeao_blog_item_wrapper_radius',
			[
				'label'      => __('Border Radius', 'power-elements'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors'  => [
					'{{WRAPPER}} .power_blog_post' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'peeao_blog_item_wrapper_margin',
			[
				'label'      => __('Margin', 'power-elements'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors'  => [
					'{{WRAPPER}} .power_blog_post' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'peeao_blog_item_wrapper_padding',
			[
				'label'      => __('Padding', 'power-elements'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors'  => [
					'{{WRAPPER}} .power_blog_post' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'peeao_blog_item_wrapper_shadow',
				'label'    => __('Box Shadow', 'power-elements'),
				'selector' => '{{WRAPPER}} .power_blog_post',
			]
		);
		$this->end_controls_section();

		/*
		* CONTENT Style
		*/
		$this->start_controls_section(
			'peeao_blog_content_style',
			[
				'label' => __('Content Wrapper', 'power-elements'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'peeao_blog_content_wrapper_bg_color',
			[
				'label'     => __('Background Color', 'power-elements'),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .power_blog_post_content' => 'background-color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'     => 'peeao_blog_content_wrapper_border',
				'label'    => __('Border', 'power-elements'),
				'selector' => '{{WRAPPER}} .power_blog_post_content',
			]
		);
		$this->add_responsive_control(
			'peeao_blog_content_wrapper_radius',
			[
				'label'      => __('Border Radius', 'power-elements'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors'  => [
					'{{WRAPPER}} .power_blog_post_content' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'peeao_blog_content_wrapper_margin',
			[
				'label'      => __('Margin', 'power-elements'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors'  => [
					'{{WRAPPER}} .power_blog_post_content' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'peeao_blog_content_wrapper_padding',
			[
				'label'      => __('Padding', 'power-elements'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors'  => [
					'{{WRAPPER}} .power_blog_post_content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'peeao_blog_content_wrapper_shadow',
				'label'    => __('Box Shadow', 'power-elements'),
				'selector' => '{{WRAPPER}} .power_blog_post_content',
			]
		);
		$this->end_controls_section();
		/*
			 * Category Style
			 */
		$this->start_controls_section(
			'peeao_blog_category_style',
			[
				'label'     => __('Category', 'power-elements'),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition'   => [
					'peeao_blog_show_category' => '1',
				],
			]
		);
		$this->add_control(
			'peeao_blog_category_label_options',
			[
				'label'     => __('Label', 'power-elements'),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'peeao_blog_category_label_typography',
				'label'    => __('Typography', 'power-elements'),
				'scheme'   => Scheme_Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .power_blog_post .power_blog_post_cat span',
			]
		);
		$this->add_control(
			'peeao_blog_category_label_color',
			[
				'label'     => __('Color', 'power-elements'),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .power_blog_post .power_blog_post_cat span' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Text_Shadow::get_type(),
			[
				'name'     => 'peeao_blog_category_label_text_shadow',
				'label'    => __('Text Shadow', 'power-elements'),
				'selector' => '{{WRAPPER}} .power_blog_post .power_blog_post_cat span',
			]
		);
		$this->add_responsive_control(
			'peeao_blog_peeao_blog_category_label_margin',
			[
				'label'      => __('Margin', 'power-elements'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors'  => [
					'{{WRAPPER}} .power_blog_post .power_blog_post_cat span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
			'peeao_blog_category_link_options',
			[
				'label'     => __('Link', 'power-elements'),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);


		$this->start_controls_tabs(
			'peeao_blog_category_link_tabs'
		);

		$this->start_controls_tab(
			'peeao_blog_category_link_normal_tab',
			[
				'label' => __('Normal', 'power-elements'),
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'peeao_blog_category_link_typography',
				'label'    => __('Typography', 'power-elements'),
				'scheme'   => Scheme_Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .power_blog_post .power_blog_post_cat a',
			]
		);
		$this->add_control(
			'peeao_blog_category_link_color',
			[
				'label'     => __('Color', 'power-elements'),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .power_blog_post .power_blog_post_cat a' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Text_Shadow::get_type(),
			[
				'name'     => 'peeao_blog_category_link_text_shadow',
				'label'    => __('Text Shadow', 'power-elements'),
				'selector' => '{{WRAPPER}} .power_blog_post .power_blog_post_cat a',
			]
		);
		$this->add_responsive_control(
			'peeao_blog_category_link_margin',
			[
				'label'      => __('Margin', 'power-elements'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors'  => [
					'{{WRAPPER}} .power_blog_post .power_blog_post_cat a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'peeao_blog_category_link_padding',
			[
				'label'      => __('Padding', 'power-elements'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors'  => [
					'{{WRAPPER}} .power_blog_post .power_blog_post_cat a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_tab();
		$this->start_controls_tab(
			'peeao_blog_category_link_hover_tab',
			[
				'label' => __('Hover', 'power-elements'),
			]
		);
		$this->add_control(
			'peeao_blog_category_link_color_hover',
			[
				'label'     => __('Color', 'power-elements'),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .power_blog_post .power_blog_post_cat a:hover' => 'color: {{VALUE}}',
				],
			]
		);
		$this->end_controls_tab();
		$this->end_controls_tabs();
		$this->end_controls_section();
		/*
			 * TITLE Style
			 */
		$this->start_controls_section(
			'peeao_blog_title_style',
			[
				'label'     => __('Title', 'power-elements'),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition'   => [
					'peeao_blog_show_title' => '1',
				],
			]
		);
		$this->start_controls_tabs(
			'peeao_blog_title_tabs'
		);

		$this->start_controls_tab(
			'peeao_blog_title_normal_tab',
			[
				'label' => __('Normal', 'power-elements'),
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'peeao_blog_title_typography',
				'label'    => __('Typography', 'power-elements'),
				'scheme'   => Scheme_Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .power_blog_post .power_blog_post_header h3.power_blog_post_title, {{WRAPPER}} .power_blog_post .power_blog_post_header h3.power_blog_post_title a',
			]
		);
		$this->add_control(
			'peeao_blog_title_color',
			[
				'label'     => __('Color', 'power-elements'),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .power_blog_post .power_blog_post_header h3.power_blog_post_title a' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_responsive_control(
			'peeao_blog_title_margin',
			[
				'label'      => __('Margin', 'power-elements'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors'  => [
					'{{WRAPPER}} .power_blog_post .power_blog_post_header h3.power_blog_post_title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'peeao_blog_title_padding',
			[
				'label'      => __('Padding', 'power-elements'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors'  => [
					'{{WRAPPER}} .power_blog_post .power_blog_post_header h3.power_blog_post_title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_tab();
		$this->start_controls_tab(
			'peeao_blog_title_hover_tab',
			[
				'label' => __('Hover', 'power-elements'),
			]
		);
		$this->add_control(
			'peeao_blog_title_color_hover',
			[
				'label'     => __('Color', 'power-elements'),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .power_blog_post .power_blog_post_header h3.power_blog_post_title a:hover' => 'color: {{VALUE}}',
				],
			]
		);
		$this->end_controls_tab();
		$this->end_controls_tabs();
		$this->end_controls_section();
		/*
			 * IMAGE Style
			 */
		$this->start_controls_section(
			'peeao_blog_image_style',
			[
				'label'     => __('Featured Image', 'power-elements'),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition'   => [
					'peeao_blog_show_image' => '1',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'     => 'peeao_blog_image_border',
				'label'    => __('Border', 'power-elements'),
				'selector' => '{{WRAPPER}} .power_blog_post .power_blog_post_img img',
			]
		);
		$this->add_responsive_control(
			'peeao_blog_image_radius',
			[
				'label'      => __('Border Radius', 'power-elements'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors'  => [
					'{{WRAPPER}} .power_blog_post .power_blog_post_img img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'peeao_blog_image_margin',
			[
				'label'      => __('Margin', 'power-elements'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors'  => [
					'{{WRAPPER}} .power_blog_post .power_blog_post_img' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'peeao_blog_image_padding',
			[
				'label'      => __('Padding', 'power-elements'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors'  => [
					'{{WRAPPER}} .power_blog_post .power_blog_post_img' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();
		/*
			 * META Style
			 */
		$this->start_controls_section(
			'peeao_blog_meta_style',
			[
				'label'     => __('Meta', 'power-elements'),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => [
					'peeao_blog_show_meta' => '1',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'peeao_blog_meta_typography',
				'label'    => __('Typography', 'power-elements'),
				'scheme'   => Scheme_Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} {{WRAPPER}} .power_blog_post .power_blog_post_meta li,{{WRAPPER}} .power_blog_post .power_blog_post_meta li a',
			]
		);
		$this->start_controls_tabs(
			'peeao_blog_meta_tabs'
		);

		$this->start_controls_tab(
			'peeao_blog_meta_normal_tab',
			[
				'label' => __('Normal', 'power-elements'),
			]
		);
		$this->add_control(
			'peeao_blog_meta_color',
			[
				'label'     => __('Color', 'power-elements'),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .power_blog_post .power_blog_post_meta li,{{WRAPPER}} .power_blog_post .power_blog_post_meta li a' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'peeao_blog_meta_icon_color',
			[
				'label'     => __('Icon Color', 'power-elements'),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .power_blog_post .power_blog_post_meta li i' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'peeao_blog_meta_advanced_day_color',
			[
				'label'     => __('Advanced Day Color', 'power-elements'),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .power_blog_post .power_blog_post_meta .power_blog_date_advanced a .day' => 'color: {{VALUE}}',
				],
				'condition'   => [
					'peeao_blog_show_date_style' => '2',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name'     => 'peeao_blog_meta_bg',
				'label'    => __( 'Background', 'power-elements' ),
				'types'    => [ 'classic', 'gradient', 'video' ],
				'selector' => '{{WRAPPER}} .power_blog_post .power_blog_post_meta li',
			]
		);
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'     => 'peeao_blog_meta_border',
				'label'    => __( 'Border', 'power-elements' ),
				'selector' => '{{WRAPPER}} .power_blog_post .power_blog_post_meta li',
			] 
		);

		$this->end_controls_tab();
		$this->start_controls_tab(
			'peeao_blog_meta_hover_tab',
			[
				'label' => __('Hover', 'power-elements'),
			]
		);
		$this->add_control(
			'peeao_blog_meta_color_hover',
			[
				'label'     => __('Color', 'power-elements'),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .power_blog_post .power_blog_post_meta li:hover a,{{WRAPPER}} .power_blog_post .power_blog_post_meta li a:hover' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'peeao_blog_meta_icon_color_hover',
			[
				'label'     => __('Icon Color', 'power-elements'),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .power_blog_post .power_blog_post_meta li:hover i' => 'color: {{VALUE}}',
					'{{WRAPPER}} .power_blog_post .power_blog_post_meta li a:hover i' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'peeao_blog_meta_advanced_day_color_hover',
			[
				'label'     => __('Advanced Day Color', 'power-elements'),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .power_blog_post .power_blog_post_meta .power_blog_date_advanced a:hover .day' => 'color: {{VALUE}}',
				],
				'condition'   => [
					'peeao_blog_show_date_style' => '1',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name'     => 'peeao_blog_meta_bg_hover',
				'label'    => __( 'Background', 'power-elements' ),
				'types'    => [ 'classic', 'gradient', 'video' ],
				'selector' => '{{WRAPPER}} .power_blog_post .power_blog_post_meta li:hover',
			]
		);
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'     => 'peeao_blog_meta_border_hover',
				'label'    => __( 'Border', 'power-elements' ),
				'selector' => '{{WRAPPER}} .power_blog_post .power_blog_post_meta li:hover',
			] 
		);
		$this->end_controls_tab();
		$this->end_controls_tabs();
		$this->add_responsive_control(
			'peeao_funfact_border_radius',
			[
				'label' => esc_html__( 'Border Radius', 'power-elements' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .power_blog_post .power_blog_post_meta li' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'peeao_blog_meta_margin',
			[
				'label'      => __('Margin', 'power-elements'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors'  => [
					'{{WRAPPER}} .power_blog_post .power_blog_post_meta li' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'peeao_blog_meta_padding',
			[
				'label'      => __('Padding', 'power-elements'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors'  => [
					'{{WRAPPER}} .power_blog_post .power_blog_post_meta li' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();
		/*
			 * EXCERPT Style
			 */
		$this->start_controls_section(
			'peeao_blog_excerpt_style',
			[
				'label'     => __('Excerpt', 'power-elements'),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => [
					'peeao_blog_show_excerpt' => '1',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'peeao_blog_excerpt_typography',
				'label'    => __('Typography', 'power-elements'),
				'scheme'   => Scheme_Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .power_blog_post .power_blog_post_intro, {{WRAPPER}} .power_blog_post .power_blog_post_intro p',
			]
		);
		$this->add_control(
			'peeao_blog_excerpt_color',
			[
				'label'     => __('Color', 'power-elements'),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .power_blog_post .power_blog_post_intro' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Text_Shadow::get_type(),
			[
				'name'     => 'peeao_blog_excerpt_text_shadow',
				'label'    => __('Text Shadow', 'power-elements'),
				'selector' => '{{WRAPPER}} .power_blog_post .power_blog_post_intro',
			]
		);
		$this->add_responsive_control(
			'peeao_blog_excerpt_margin',
			[
				'label'      => __('Margin', 'power-elements'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors'  => [
					'{{WRAPPER}} .power_blog_post .power_blog_post_intro' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'peeao_blog_excerpt_padding',
			[
				'label'      => __('Padding', 'power-elements'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors'  => [
					'{{WRAPPER}} .power_blog_post .power_blog_post_intro' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();
		/*
			 * READ MORE Style
			 */
		$this->start_controls_section(
			'peeao_blog_read_more_style',
			[
				'label'     => __('Read More', 'power-elements'),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => [
					'peeao_blog_show_read_more' => '1',
				],
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'peeao_blog_read_more_typography',
				'label'    => __('Typography', 'power-elements'),
				'scheme'   => Scheme_Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .power_blog_button',
			]
		);
		$this->add_responsive_control(
			'peeao_blog_read_more_align',
			[
				'label'     => __('Alignment', 'power-elements'),
				'type'      => Controls_Manager::CHOOSE,
				'options'   => [
					'left'   => [
						'title' => __('Left', 'power-elements'),
						'icon'  => 'fa fa-align-left',
					],
					'center' => [
						'title' => __('Center', 'power-elements'),
						'icon'  => 'fa fa-align-center',
					],
					'right'  => [
						'title' => __('Right', 'power-elements'),
						'icon'  => 'fa fa-align-right',
					]
				],
				'selectors' => [
					'{{WRAPPER}} .power_blog_button_group' => 'text-align: {{VALUE}};'
				],
			]
		);
		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'peeao_blog_read_more_box_shadow',
				'label'    => __('Box Shadow', 'power-elements'),
				'selector' => '{{WRAPPER}} .power_blog_button',
			]
		);
		$this->add_responsive_control(
			'peeao_blog_read_more_radius',
			[
				'label'      => __('Border Radius', 'power-elements'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors'  => [
					'{{WRAPPER}} .power_blog_button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'peeao_blog_read_more_padding',
			[
				'label'      => __('Padding', 'power-elements'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors'  => [
					'{{WRAPPER}} .power_blog_button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->start_controls_tabs(
			'peeao_blog_read_more_tabs'
		);

		$this->start_controls_tab(
			'peeao_blog_read_more_normal_tab',
			[
				'label' => __('Normal', 'power-elements'),
			]
		);
		$this->add_control(
			'peeao_blog_read_more_color',
			[
				'label'     => __('Color', 'power-elements'),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .power_blog_button' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'peeao_blog_read_more_bg_color',
			[
				'label'     => __('Background Color', 'power-elements'),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .power_blog_button:after' => 'background-color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'     => 'peeao_blog_read_more_border',
				'label'    => __('Border', 'power-elements'),
				'selector' => '{{WRAPPER}} .power_blog_button',
			]
		);
		$this->end_controls_tab();
		$this->start_controls_tab(
			'peeao_blog_read_more_hover_tab',
			[
				'label' => __('Hover', 'power-elements'),
			]
		);
		$this->add_control(
			'peeao_blog_read_more_color_hover',
			[
				'label'     => __('Color', 'power-elements'),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .power_blog_button:hover' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name'     => 'peeao_blog_read_more_background',
				'label'    => __('Background', 'power-elements'),
				'types'    => ['gradient'],
				'selector' => '{{WRAPPER}} .power_blog_button:before',
			]
		);
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'     => 'peeao_blog_read_more_border_hover',
				'label'    => __('Border', 'power-elements'),
				'selector' => '{{WRAPPER}} .power_blog_button:hover',
			]
		);
		$this->end_controls_tab();
		$this->end_controls_tabs();
		$this->end_controls_section();
	}


	/**
	 * Render social widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render()
	{
		$settings = $this->get_settings();

		/**
		 * Setup the post arguments.
		 */

		$post_args  = Partials::get_post_settings($settings);
		$query_args = Partials::get_query_args('powerpost', $settings, 'blog');
		$query_args = array_merge($query_args, $post_args, $settings);

		if (isset($query_args['tax_query'])) {
			$tax_query = $query_args['tax_query'];
		}
		/**
		 * Get posts from database. 
		 */
		$posts = Partials::load_blog_posts($query_args, 'blog');
		/**
		 * Set total posts.
		 */
?>
		<div class="peeao-wrapper">
			<div id="power-post-grid-<?php echo esc_attr($this->get_id()); ?>" class="power-post-grid-container">
				<div class="row">
					<?php
					if (!empty($posts['content'])) {
						echo $posts['content'];
					} else {
						echo '<p class="text-danger">' . esc_html__('Something went wrong.', 'power-elements') . '</p>';
					}
					?>
				</div>
			</div>
		</div>
<?php
	}

	/**
	 * Render social widget output in the editor.
	 *
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 *
	 * @since 1.0.0
	 * @access protected
	 */

	protected function _content_template()
	{
	}
}
