<?php
namespace PowerElements\Override;

use Elementor\Controls_Manager;
use Elementor\Element_Base;

defined( 'ABSPATH' ) || die();

class Settings {
    public function __construct() {
        add_action( 'elementor/element/page-settings/section_page_style/before_section_end', [ __CLASS__, 'add_controls_section'] );
        add_action( 'elementor/element/page-settings/_section_power_page_settings/after_section_start', [ __CLASS__, 'add_page_settings' ] );
        add_action( 'elementor/element/after_add_attributes', [ $this, 'render_attributes' ] );
    }

    public static function add_controls_section( Element_Base $element ) {
        $element->start_controls_section(
            '_section_power_page_settings',
            [
                'label' => esc_html__( 'Power Display Conditions', 'power-elements' ),
                'tab' => Controls_Manager::TAB_ADVANCED,
            ]
        );
        $element->end_controls_section();
    }
    public static function add_page_settings( Element_Base $element ) {
        $element->add_control(
			'peeao_page_settings',
			[
				'label' => esc_html__( 'Sticky', 'power-elements' ),
				'type' => Controls_Manager::SWITCHER,
                'default' => 'no',
                'label_on' =>esc_html__( 'Yes', 'power-elements' ),
                'label_off' =>esc_html__( 'No', 'power-elements' ),
			]
		);
    }

    /**
	 * @param $element Element_Base
	 */
	public function render_attributes( Element_Base $element ) {
        $settings = $element->get_settings_for_display();
        if ( $settings['peeao_effects_sticky'] == 'yes' ) {
            $element->add_render_attribute( '_wrapper', 'class', 'power-sticky-section' );
        }
	}
}