<?php
namespace PowerElements\Frontend;

defined( 'ABSPATH' ) || die();

class Enqueue { 

    public function __construct() {
        add_action( 'elementor/frontend/after_register_styles', [$this, 'widget_register_styles']);
        add_action( 'wp_enqueue_scripts', [$this, 'widget_enqueue_styles']);
        add_action( 'elementor/editor/after_enqueue_styles', [$this, 'widget_enqueue_styles']);
        add_action( 'elementor/preview/enqueue_styles', [$this, 'widget_enqueue_styles']);
    
        add_action( 'elementor/frontend/after_enqueue_scripts', [$this, 'widget_script'] );
        add_action( 'elementor/editor/after_enqueue_styles', [$this, 'editor_enqueue_styles' ] );
        add_action( 'elementor/editor/before_enqueue_scripts', [ $this, 'layouts_scripts' ], 1);
        add_action( 'elementor/editor/footer', [$this, 'layouts_inline_js'] );
        add_action( 'elementor/editor/after_enqueue_styles', [ $this, 'layouts_styles' ] );
        add_action( 'elementor/preview/enqueue_styles', [ $this, 'layouts_preview_styles' ] );
         
    }
    
    public function layouts_scripts(){
        wp_enqueue_script( 
            'power-modal-editor-script', 
            POWER_ELEMENTS_LAYOUT_JS_DIR_URL . '/editor.min.js', 
            array('jquery', 'underscore', 'backbone-marionette'), 
            POWER_ELEMENTS_VERSION,
            true
        );
    }

    public function layouts_styles(){
        wp_enqueue_style( 'power-modal-editor-style', 
        POWER_ELEMENTS_LAYOUT_CSS_DIR_URL . '/editor.min.css', [], POWER_ELEMENTS_VERSION);
    }

    public function layouts_preview_styles(){
        wp_enqueue_style( 'power-modal-preview-style',
        POWER_ELEMENTS_LAYOUT_CSS_DIR_URL . '/preview.min.css', [], POWER_ELEMENTS_VERSION );
    
    }
    public function layouts_inline_js() { ?>
        <script type="text/javascript" >

        var powerElementsLibreryData = {
            "libraryButton": "Elements Button",
            "modalRegions": {
                "modalHeader": ".dialog-header",
                "modalContent": ".dialog-message"
            },
            "tabs": {
                "power_page": {
                    "title": "Pages",
                    "data": [],
                    "source": ["power-theme", "power-api"],
                    "settings": {
                        "show_title": true,
                        "show_keywords": true
                    }
                },
                "power_header": {
                    "title": "Headers",
                    "data": [],
                    "source": ["power-theme", "power-api"],
                    "settings": {
                        "show_title": false,
                        "show_keywords": true
                    }
                },
                "power_footer": {
                    "title": "Footers",
                    "data": [],
                    "source": ["power-theme", "power-api"],
                    "settings": {
                        "show_title": false,
                        "show_keywords": true
                    }
                },
                "power_section": {
                    "title": "Sections",
                    "data": [],
                    "source": ["power-theme", "power-api"],
                    "settings": {
                        "show_title": false,
                        "show_keywords": true
                    }
                },
                "power_element": {
                    "title": "Elements",
                    "data": [],
                    "source": ["power-theme", "power-api"],
                    "settings": {
                        "show_title": false,
                        "show_keywords": true
                    }
                },
            },
            "defaultTab": "power_page"
        };

        </script> <?php
    }
    public function widget_register_styles() {
        wp_register_style( 'power-elements-libraries',  
            POWER_ELEMENTS_CSS_DIR_URL . '/libraries.min.css');
        wp_register_style( 'power-elements-widgets', 
            POWER_ELEMENTS_CSS_DIR_URL . '/widgets.min.css' );
    } 
    public function widget_enqueue_styles() {
        wp_enqueue_style( 'power-elements-libraries' );
        wp_enqueue_style( 'power-elements-widgets' );
    } 
    
    public function editor_enqueue_styles() {
        wp_register_style( 'power-elements-widgets-panel', 
            POWER_ELEMENTS_ADMIN_CSS_DIR_URL . '/panel.min.css' );
        wp_enqueue_style( 'power-elements-widgets-panel' );
    }
    public function widget_script() {
        wp_enqueue_script( 'power-elements-libraries', 
            POWER_ELEMENTS_JS_DIR_URL . '/libraries.min.js',
            [ 'jquery'],
            false,
            false 
        );
        wp_enqueue_script( 'power-elements-widgets',
            POWER_ELEMENTS_JS_DIR_URL . '/widgets.min.js',
            [ 'jquery'],
            '1.0',
            true
        );
    }
}
