<?php
namespace PowerElements\Cptui;

if ( !defined( 'ABSPATH' ) )
	die( 'Direct access forbidden.' );

class Init {

	private static $initialized	 = false;
    public function __construct() {
    
		$cpt = new Cpt( 'power_elements' );		
		$cpt_tax = new  CptTax('power_elements');
 
		$cpt->init( 
			'peeao_portfolio', 
			'Portfolio', 
			'Portfolios', 
			[ 'menu_icon'	 => 
				'dashicons-exerpt-view',
				'supports'	 => [
					'title', 
					'editor', 
					'excerpt', 
					'thumbnail' 
				],
				'rewrite'	 => [
					'slug' => 'peeao_portfolio' 
				]
			]
		);
		$cpt_tax->init(
			'peeao_portfolio_cat', 
			'Portfolio Category', 
			'Portfolio Categories', 
			'peeao_portfolio',
			'manage_categories'
		);

		$cpt->init( 
			'peeao_header_footer', 
			'Header Footer', 
			'Header Footer', 
			[ 'menu_icon'	 => 
				'dashicons-exerpt-view',
				'supports'	 => [
					'title', 
					'editor', 
				],
				'rewrite'	 => [
					'slug' => 'peeao_header_footer' 
				]
			]
		);
		$cpt_tax->init(
			'peeao_header_footer_cat', 
			'Position', 
			'Position', 
			'peeao_header_footer',
			''
		);

		$cpt->init( 
			'peeao_nested', 
			'Nested Template', 
			'Nested Templates', 
			[ 'menu_icon'	 => 
				'dashicons-exerpt-view',
				'supports'	 => [
					'title', 
					'editor', 
				],
				'rewrite'	 => [
					'slug' => 'peeao_nested' 
				]
			]
		);
		$cpt->init( 
			'peeao_block', 
			'Block', 
			'Blocks', 
			[ 'menu_icon'	 => 
				'dashicons-exerpt-view',
				'supports'	 => [
					'title', 
					'editor', 
				],
				'rewrite'	 => [
					'slug' => 'peeao_block' 
				]
			]
		);
		// $cpt->init( 
		// 	'peeao_form', 
		// 	'Forms', 
		// 	'Forms', 
		// 	[ 'menu_icon'	 => 
		// 		'dashicons-exerpt-view',
		// 		'supports'	 => [
		// 			'title', 
		// 			'editor', 
		// 		],
		// 		'rewrite'	 => [
		// 			'slug' => 'peeao_form' 
		// 		]
		// 	]
		// );
		
		if ( self::$initialized ) {
			return;
		} else {
			self::$initialized = true;
		}

		add_action('init', [ __CLASS__, 'insert_terms' ]);
		add_action('single_template', [ __CLASS__, 'set_page_template' ], 10, 3 );
		add_action('init', [ __CLASS__, 'add_elementor_support' ], 10, 3 );
		 
	}
	
		
	public static function insert_terms(){
		$h_term = wp_insert_term(
			'Header',
			'peeao_header_footer_cat',
			array(
				'description' => 'Shows on Header',
				'slug'        => 'peeao_header_term',
				'parent'      => 0,
			)
		);
		$f_term = wp_insert_term(
			'Footer',
			'peeao_header_footer_cat',
			array(
				'description' => 'Shows on Footer',
				'slug'        => 'peeao_footer_term',
				'parent'      => 0,
			)
		);
	}

	public static function set_page_template( $template ) {
		global $post;
		$template_path = ELEMENTOR_PATH . '/modules/page-templates/templates/canvas.php';
		if ('peeao_header_footer' === $post->post_type || 
			'peeao_nested' === $post->post_type || 
			'peeao_template' === $post->post_type || 
			'peeao_form' === $post->post_type || 
			'peeao_block' === $post->post_type 
		){
			if ( file_exists( $template_path ) ) {
				return $template_path;
			} else {
				return ELEMENTOR_PATH . '/includes/page-templates/canvas.php';
			}
		}
		return $template;
	}

	public static function add_elementor_support() {
		$elementor_support = get_option( 'elementor_cpt_support' );
		$default_supports = [ 'peeao_header_footer', 'peeao_nested',  'peeao_block', 'peeao_template', 'peeao_form' ];
		if( ! $elementor_support ) {
			$elementor_support = $default_supports;
		}else{
			foreach($default_supports as $default_support){
				if( ! in_array( $default_support, $elementor_support ) ) {
					$elementor_support[] = $default_support;
				}
			}
		}
		update_option( 'elementor_cpt_support', $elementor_support );
	}
}