<?php
namespace PowerElements\Admin;

defined( 'ABSPATH' ) || die();

class Enqueue { 

    public function __construct() {

        add_action( 'admin_enqueue_scripts', [ __CLASS__, 'admin_enqueue_scripts' ] );
         
    }
    
    public static function admin_enqueue_scripts( $hook ) {
        if ( ! current_user_can( 'manage_options' ) ) {
            return;
        }

        wp_enqueue_style( 
            'power-elements-framework',
            POWER_ELEMENTS_CSS_DIR_URL . '/libraries.min.css', 
            null,
            '1.0'
        );
        
        wp_enqueue_style(
            'power-elements-font-awesome',
            POWER_ELEMENTS_ADMIN_CSS_DIR_URL . '/font-awesome.min.css',
            null,
            '1.0'
        );
        wp_enqueue_style(
            'power-elements-admin',
            POWER_ELEMENTS_ADMIN_CSS_DIR_URL . '/admin.min.css',
            null,
            '1.0'
        );
        wp_enqueue_style(
            'power-elements-dashboard',
            POWER_ELEMENTS_ADMIN_CSS_DIR_URL . '/dashboard.min.css',
            null,
            '1.0'
        );

        // wp_enqueue_script(
        //     'power-elements-dashboard-bootstrap',
        //     POWER_ELEMENTS_ADMIN_JS_DIR_URL . '/bootstrap.min.js',
        //     [ 'jquery' ],
        //     '1.0',
        //     true
        // );

        wp_enqueue_script(
            'power-elements-admin',
            POWER_ELEMENTS_ADMIN_JS_DIR_URL . '/admin.min.js',
            [ 'jquery' ],
            '1.0',
            true
        );

        wp_enqueue_script(
            'power-elements-dashboard',
            POWER_ELEMENTS_ADMIN_JS_DIR_URL . '/dashboard.min.js',
            [ 'jquery' ],
            '1.0',
            true
        );

    }
}
