<?php
namespace PowerElements;

use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class PowerElements_WPCF7 extends Widget_Base {

	public function get_name() { 
		return 'power_elements_wpcf7';
	}
	public function get_title() {
		return __( 'Contact Form 7', 'power-elements' );
	}
	public function get_icon() {
		return 'eicon-form-horizontal';
    }
    public function get_categories() {
		return [ 'power-elements' ];
	}
	protected function peeao_is_wpcf7_activated(){
		return class_exists( 'WPCF7' );
	}
    protected function _register_controls() {

  		$this->start_controls_section(
  			'peeao_section_wpcf7_form',
  			[
  				'label' => __( 'Contact Form', 'power-elements' )
  			]
  		);

		$this->add_control( 
			'peeao_wpcf7_form',
			[
				'label' => __( 'Select Your Contact Form', 'power-elements' ),
				'label_block' => true,
				'type' => Controls_Manager::SELECT,
				'options' => $this->peeao_contact_form(),
			]
		);

		if ( ! $this->peeao_is_wpcf7_activated() ) {
            $this->add_control(
                'peeao_wpcf7_missing_notice',
                [
                    'type' => Controls_Manager::RAW_HTML,
                    'raw' => sprintf(
                        __( 'Hello, looks like %1$s is missing in your site. Please click on the link below and install/activate %1$s. Make sure to refresh this page after installation or activation.', 'power-elements' ),
                        '<a href="'.esc_url( admin_url( 'plugin-install.php?s=Contact+Form+7&tab=search&type=term' ) )
                        .'" target="_blank" rel="noopener">Contact Form 7</a>'
                    ),
                    'content_classes' => 'elementor-panel-alert elementor-panel-alert-danger',
                ]
            );

            $this->add_control(
                'peeao_wpcf7_install',
                [
                    'type' => Controls_Manager::RAW_HTML,
                    'raw' => '<a href="'.esc_url( admin_url( 'plugin-install.php?s=Contact+Form+7&tab=search&type=term' ) ).'" target="_blank" rel="noopener">Click to install or activate Contact Form 7</a>',
                ]
            );
            return;
        }
		$this->end_controls_section();
        
        $this->start_controls_section('peeao_wpcf7_settings', 
            [
                'label'     => __('Settings', 'power-elements'),
			]
		);
        
        $this->add_control('peeao_wpcf7_settings_heading',
            [
                'label'     => __('Width', 'power-elements'),
                'type'      => Controls_Manager::HEADING
			]
		);
        
        $this->add_responsive_control(
  			'peeao_wpcf7_settings_input_width',
  			[
  				'label' => __( 'Input Field', 'power-elements' ),
  				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em', '%' ],
				'range' => [
					'px' => [
						'min' => 10,
						'max' => 1200,
					],
					'em' => [
						'min' => 1,
						'max' => 80,
					],
				],
                'default'   => [
                    'size'  => 100,
                    'unit'  => '%'
                ],
				'selectors' => [
					'{{WRAPPER}} .peeao-wrapper .power-cf7-container input.wpcf7-text' => 'width: {{SIZE}}{{UNIT}};',
				],
  			]
  		);

        $this->add_responsive_control(
  			'peeao_wpcf7_settings_textarea_width',
  			[
  				'label' => __( 'Text Area', 'power-elements' ),
  				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em', '%' ],
				'range' => [
					'px' => [
						'min' => 10,
						'max' => 1200,
					],
					'em' => [
						'min' => 1,
						'max' => 80,
					],
				],
                'default'   => [
                    'size'  => 100,
                    'unit'  => '%'
                ],
				'selectors' => [
					'{{WRAPPER}} .peeao-wrapper .power-cf7-container textarea.wpcf7-textarea' => 'width: {{SIZE}}{{UNIT}};',
				],
  			]
		);  

        /*Button Width*/
        $this->add_responsive_control(
			'peeao_wpcf7_button_width',
			[
				'label' => __( 'Button', 'power-elements' ),
				'type' => Controls_Manager::SLIDER,
			  'size_units' => [ 'px', 'em', '%' ],
			  'range' => [
				  'px' => [
					  'min' => 10,
					  'max' => 1200,
				  ],
				  'em' => [
					  'min' => 1,
					  'max' => 80,
				  ],
			  ],
			  'selectors' => [
				  '{{WRAPPER}} .peeao-wrapper .power-cf7-container input.wpcf7-submit' => 'width: {{SIZE}}{{UNIT}};',
			  ],
			]
		);  
        $this->add_control('peeao_wpcf7_settings_height_heading',
            [
                'label'     => __('Height', 'power-elements'),
                'type'      => Controls_Manager::HEADING
			]
		);
        
        $this->add_responsive_control(
  			'peeao_wpcf7_settings_input_height',
  			[
  				'label' => __( 'Input Field', 'power-elements' ),
  				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em' ],
				'range' => [
					'px' => [
						'min' => 10,
						'max' => 500,
					],
					'em' => [
						'min' => 1,
						'max' => 40,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .peeao-wrapper .power-cf7-container input.wpcf7-text' => 'height: {{SIZE}}{{UNIT}};',
				],
  			]
  		);
        
        $this->add_responsive_control(
  			'peeao_wpcf7_settings_textarea_height',
  			[
  				'label' => __( 'Text Area', 'power-elements' ),
  				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em' ],
				'range' => [
					'px' => [
						'min' => 10,
						'max' => 1200,
					],
					'em' => [
						'min' => 1,
						'max' => 80,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .peeao-wrapper .power-cf7-container textarea.wpcf7-textarea' => 'height: {{SIZE}}{{UNIT}};',
				],
  			]
		); 
		
        /*Button Height*/
        $this->add_responsive_control(
			'peeao_wpcf7_settings_button_height',
			[
				'label' => __( 'Button', 'power-elements' ),
				'type' => Controls_Manager::SLIDER,
			  'size_units' => [ 'px', 'em' ],
			  'range' => [
				  'px' => [
					  'min' => 10,
					  'max' => 500,
				  ],
				  'em' => [
					  'min' => 1,
					  'max' => 40,
				  ],
			  ],
			  'selectors' => [
				  '{{WRAPPER}} .peeao-wrapper .power-cf7-container input.wpcf7-submit' => 'height: {{SIZE}}{{UNIT}};',
			  ],
			]
		);
        $this->end_controls_section();
                
        $this->start_controls_section(
			'section_contact_form_styles',
			[
				'label' => __( 'Form', 'power-elements' ),
				'tab' => Controls_Manager::TAB_STYLE
			]
		);
        $this->add_control(
			'peeao_wpcf7_input_background',
			[
				'label' => __( 'Input Field Background', 'power-elements' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .peeao-wrapper .power-cf7-container input.wpcf7-text, {{WRAPPER}} .peeao-wrapper .power-cf7-container textarea.wpcf7-textarea' => 'background: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'peeao_wpcf7_input_color',
			[
				'label' => __( 'Input Field Color', 'power-elements' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .peeao-wrapper .power-cf7-container input.wpcf7-text' => 'color: {{VALUE}};',
					'{{WRAPPER}} .peeao-wrapper .power-cf7-container textarea.wpcf7-textarea' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'peeao_wpcf7_input_placeholder_color',
			[
				'label' => __( 'Placeholder Color', 'power-elements' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .peeao-wrapper .power-cf7-container ::-webkit-input-placeholder' => 'color: {{VALUE}};',
					'{{WRAPPER}} .peeao-wrapper .power-cf7-container ::-moz-placeholder' => 'color: {{VALUE}};',
					'{{WRAPPER}} .peeao-wrapper .power-cf7-container :-ms-input-placeholder' => 'color: {{VALUE}};',
					'{{WRAPPER}} .peeao-wrapper .power-cf7-container :-moz-placeholder' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(), [
				'name'		 => 'peeao_wpcf7_input_typpography',
				'selector'	 => '{{WRAPPER}} .peeao-wrapper .power-cf7-container input.wpcf7-text,{{WRAPPER}} .peeao-wrapper .power-cf7-container textarea.wpcf7-textarea',
			]
		);
        $this->add_responsive_control(
			'peeao_wpcf7_input_padding',
			[
				'label' => __( 'Padding', 'power-elements' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors' => [
					'{{WRAPPER}} .peeao-wrapper .power-cf7-container input.wpcf7-text, {{WRAPPER}} .peeao-wrapper .power-cf7-container textarea.wpcf7-textarea' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);            
                
        $this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'peeao_wpcf7_input_border',
				'selector' => '{{WRAPPER}} .peeao-wrapper .power-cf7-container input.wpcf7-text, {{WRAPPER}} .peeao-wrapper .power-cf7-container textarea.wpcf7-textarea',
			]
		);
                
        $this->add_responsive_control(
			'peeao_wpcf7_input_border_radius',
			[
				'label' => __( 'Border Radius', 'power-elements' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px' ],
				'selectors' => [
					'{{WRAPPER}} .peeao-wrapper .power-cf7-container input.wpcf7-text, {{WRAPPER}} .peeao-wrapper .power-cf7-container textarea.wpcf7-textarea' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'peeao_wpcf7_input_margin',
			[
				'label' => __( 'Margin', 'power-elements' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors' => [
					'{{WRAPPER}} .peeao-wrapper .power-cf7-container input.wpcf7-text, {{WRAPPER}} .peeao-wrapper .power-cf7-container textarea.wpcf7-textarea' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		
		$this->add_control(
			'peeao_wpcf7_input_focus',
			[
				'label' => __( 'Focus Border Color', 'power-elements' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .peeao-wrapper .power-cf7-container input.wpcf7-text:focus, {{WRAPPER}} .peeao-wrapper .power-cf7-container textarea.wpcf7-textarea:focus' => 'border-color: {{VALUE}};',
				],
			]
		);
                
        $this->add_control(
			'peeao_wpcf7_input_focus_border_animation',
			[
				'label' => __( 'Focus Border Animation', 'power-elements' ),
				'type'	=> Controls_Manager::SELECT,
                'options'		=> [
					'peeao_border_animation1'		=> 'On',
					'peeao_border_animation2'		=> 'Off',
				],
            	'default'       => 'peeao_border_animation2',
			]
		);
                		
        $this->add_control(
			'peeao_wpcf7_input_focus_border_color',
			[
				'label' => __( 'Focus Line Color', 'power-elements' ),
				'type' => Controls_Manager::COLOR,
            	'condition'		=> [
					'peeao_wpcf7_input_focus_border_animation' => 'peeao_border_animation1'
				],
				'selectors' => [
					'{{WRAPPER}} .peeao_border_animation1 .wpcf7-span.is-focused::after' => 'background-color: {{VALUE}};',
				],
			]
		);
                
        $this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'input_button_shadow',
				'selector' => '{{WRAPPER}} .peeao-wrapper .power-cf7-container input.wpcf7-text, {{WRAPPER}} .peeao-wrapper .power-cf7-container textarea.wpcf7-textarea',
			]
		);
                
                
    	$this->end_controls_section();
		  
		
		$this->start_controls_section(
			'section_contact_form_typography',
			[
				'label' => __( 'Labels', 'power-elements' ),
				'tab' => Controls_Manager::TAB_STYLE
			]
		);
		
                
        $this->add_control(
			'peeao_wpcf7_heading_default',
			[
				'type' => Controls_Manager::HEADING,
				'label' => __( 'Default Typography', 'power-elements' ),
			]
		);
		
		$this->add_control(
			'peeao_wpcf7_contact_form_color',
			[
				'label' => __( 'Default Font Color', 'power-elements' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .power-cf7-container, {{WRAPPER}} .peeao-wrapper .power-cf7-container label' => 'color: {{VALUE}};',
				],
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'peeao_wpcf7_contact_form_default_typography',
				'selector' => '{{WRAPPER}} .power-cf7-container',
			]
		);
        
      	$this->add_control(
			'peeao_wpcf7_heading_input',
			[
				'type' => Controls_Manager::HEADING,
				'label' => __( 'Input Typography', 'power-elements' ),
            'separator' => 'before',
			]
		);
		
		$this->add_control(
			'peeao_wpcf7_contact_form_field_color',
			[
				'label' => __( 'Input Text Color', 'power-elements' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .peeao-wrapper .power-cf7-container input.wpcf7-text, {{WRAPPER}} .peeao-wrapper .power-cf7-container textarea.wpcf7-textarea' => 'color: {{VALUE}};',
				],
			]
		);
        
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'peeao_wpcf7_contact_form_field_typography',
				'selector' => '{{WRAPPER}} .peeao-wrapper .power-cf7-container input.wpcf7-text, {{WRAPPER}} .peeao-wrapper .power-cf7-container textarea.wpcf7-textarea',
			]
		);
        
		
		$this->add_control(
			'peeao_wpcf7_contact_form_placeholder_color',
			[
				'label' => __( 'Placeholder Color', 'power-elements' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .peeao-wrapper .power-cf7-container ::-webkit-input-placeholder' => 'color: {{VALUE}};',
					'{{WRAPPER}} .peeao-wrapper .power-cf7-container ::-moz-placeholder' => 'color: {{VALUE}};',
					'{{WRAPPER}} .peeao-wrapper .power-cf7-container ::-ms-input-placeholder' => 'color: {{VALUE}};',
				],
			]
		);
	
		
		$this->end_controls_section();
                         
        $this->start_controls_section(
			'section_contact_form_submit_button_styles',
			[
				'label' => __( 'Button', 'power-elements' ),
				'tab' => Controls_Manager::TAB_STYLE
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
             'name' => 'section_title_peeao_btn_typography',
				'selector' => '{{WRAPPER}} .peeao-wrapper .power-cf7-container input.wpcf7-submit',
			]
		);
		
		$this->add_responsive_control(
			'section_title_peeao_btn_padding',
			[
				'label' => __( 'Padding', 'power-elements' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors' => [
					'{{WRAPPER}} .peeao-wrapper .power-cf7-container input.wpcf7-submit' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		
		
		
		$this->start_controls_tabs( 'peeao_wpcf7_button_tabs' );

		$this->start_controls_tab( 'normal', [ 'label' => __( 'Normal', 'power-elements' ) ] );

		$this->add_control(
			'peeao_wpcf7_button_text_color',
			[
				'label' => __( 'Text Color', 'power-elements' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .peeao-wrapper .power-cf7-container input.wpcf7-submit' => 'color: {{VALUE}};',
				],
			]
		);
		

		
		$this->add_control(
			'peeao_wpcf7_button_background_color',
			[
				'label' => __( 'Background Color', 'power-elements' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .peeao-wrapper .power-cf7-container input.wpcf7-submit' => 'background-color: {{VALUE}};',
				],
			]
		);
		
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'peeao_wpcf7_btn_border',
				'selector' => '{{WRAPPER}} .peeao-wrapper .power-cf7-container input.wpcf7-submit',
			]
		);
		
		$this->add_responsive_control(
			'peeao_wpcf7_btn_border_radius',
			[
				'label' => __( 'Border Radius', 'power-elements' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .peeao-wrapper .power-cf7-container input.wpcf7-submit' => 'border-radius: {{SIZE}}px;',
				],
			]
		);
		

		
		$this->end_controls_tab();

		$this->start_controls_tab( 'peeao_wpcf7_hover', [ 'label' => __( 'Hover', 'power-elements' ) ] );

		$this->add_control(
			'peeao_wpcf7_button_hover_text_color',
			[
				'label' => __( 'Text Color', 'power-elements' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .peeao-wrapper .power-cf7-container input.wpcf7-submit:hover' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'peeao_wpcf7_button_hover_background_color',
			[
				'label' => __( 'Background Color', 'power-elements' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .peeao-wrapper .power-cf7-container input.wpcf7-submit:hover' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'peeao_wpcf7_button_hover_border_color',
			[
				'label' => __( 'Border Color', 'power-elements' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .peeao-wrapper .power-cf7-container input.wpcf7-submit:hover' => 'border-color: {{VALUE}};',
				],
			]
		);
		
		$this->end_controls_tab();
		
		$this->end_controls_tabs();
		
		
		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'button_box_shadow',
				'selector' => '{{WRAPPER}} .peeao-wrapper .power-cf7-container input.wpcf7-submit',
			]
		);
		
		
		$this->end_controls_section();
                
    }
        
    protected function peeao_contact_form( ) {

		if ( ! class_exists( 'WPCF7_ContactForm' ) ) {
			return [];
		}

		$forms = \WPCF7_ContactForm::find( [
				'orderby' => 'title',
				'order'   => 'ASC',
			] 
		);

		if ( empty( $forms ) ) {
			return [];
		}

		$result = [];

		foreach ( $forms as $item ) {
			$key            = sprintf( '%1$s::%2$s', $item->id(), $item->title() );
			$result[ $key ] = $item->title();
		}

		return $result;
	}
    
    protected function render() {

		$settings = $this->get_settings();
		if ( ! $this->peeao_is_wpcf7_activated() || empty( $settings['peeao_wpcf7_form'] )) {
			return;
		} ?>
		<div class="peeao-wrapper">
			<div class="power-cf7-container <?php echo $settings['peeao_wpcf7_input_focus_border_animation'];?>">
				<?php echo do_shortcode( '[contact-form-7 id="' . $settings['peeao_wpcf7_form'] . '" ]' );?>
			</div>
        </div>
        
	<?php }
}