<?php
namespace PowerElements;
use PowerElements\Helpers\Partials as Partials;
use PowerElements\Helpers\Utils as Utils;

use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Scheme_Typography;
use \Elementor\Group_Control_Text_Shadow;


	if ( ! defined( 'ABSPATH' ) ) {
		exit; // Exit if accessed directly.
	}
	
	/**
	 * Power Element social widget.
	 *
	 * Elementor widget that displays a social with the ability to control every
	 * aspect of the social design.
	 *
	 * @since 1.0.0
	 */
	class PowerElements_Testimonial extends Widget_Base {
		
		/**
		 * Get widget name.
		 *
		 * Retrieve social widget name.
		 *
		 * @since 1.0.0
		 * @access public
		 *
		 * @return string Widget name.
		 */
		public function get_name() {
			return 'power_elements_testimonial';
		}
		
		/**
		 * Get widget title.
		 *
		 * Retrieve social widget title.
		 *
		 * @since 1.0.0
		 * @access public
		 *
		 * @return string Widget title.
		 */
		public function get_title() {
			return __( 'Testimonial', 'power-elements' );
		}
		
		/**
		 * Get widget icon.
		 *
		 * Retrieve social widget icon.
		 *
		 * @since 1.0.0
		 * @access public
		 *
		 * @return string Widget icon.
		 */
		public function get_icon() {
			return 'eicon-testimonial';
		}
		
		/**
		 * Get widget categories.
		 *
		 * Retrieve the list of categories the social widget belongs to.
		 *
		 * Used to determine where to display the widget in the editor.
		 *
		 * @since 2.0.0
		 * @access public
		 *
		 * @return array Widget categories.
		 */
		public function get_categories() {
			return [ 'power-elements' ];
		}
		
		/**
		 * Register social widget controls.
		 *
		 * Adds different input fields to allow the user to change and customize the widget settings.
		 *
		 * @since 1.0.0
		 * @access protected
		 */
		protected function _register_controls() {
			$this->start_controls_section(
				'peeao_testimonial_content_tab',
				[
					'label' => __( 'Testimonial Content', 'power-elements' ),
					'tab'   => Controls_Manager::TAB_CONTENT,
				]
			);
			$this->add_control(
				'peeao_testimonial_style',
				[
					'label'   => __( 'Style', 'power-elements' ),
					'type'    => Controls_Manager::SELECT,
					'default' => 'style_2',
					'options' => [
						'style_1' => __( 'Style 1', 'power-elements' ),
						'style_2' => __( 'Style 2', 'power-elements' ),
						'style_3' => __( 'Style 3', 'power-elements' ),
						'style_4' => __( 'Style 4', 'power-elements' ),
						'style_5' => __( 'Style 5', 'power-elements' ),
						'style_6' => __( 'Style 6', 'power-elements' ),
						'style_7' => __( 'Style 7', 'power-elements' ),
						'style_8' => __( 'Style 8', 'power-elements' ),
						'style_9' => __( 'Style 9', 'power-elements' ),
					]
				]
			);
			$this->add_control(
				'peeao_testimonial_quote_image',
				[
					'label'   => __('Choose Quote Image', 'power-elements'),
					'type'    => Controls_Manager::MEDIA,
					'default' => [
						'url' => \Elementor\Utils::get_placeholder_image_src(),
					],
					'condition' => [
						'peeao_testimonial_style' => 'style_9',
					]
				]
			);
			$this->add_control(
				'peeao_testimonial_quote_watermark',
				[
					'label'   => __('Use Watermark Quote', 'power-elements'),
					'type'    => Controls_Manager::CHOOSE,
					'options' => [
						'1' => [
							'title' => __('Yes', 'power-elements'),
							'icon'  => 'fa fa-check',
						],
						'0' => [
							'title' => __('No', 'power-elements'),
							'icon'  => 'fa fa-ban',
						],
					],
					'default' => '1',
				]
			);
			$this->add_control(
				'peeao_testimonial_name_text',
				[
					'label'       => __( 'Name', 'power-elements' ),
					'type'        => Controls_Manager::TEXT,
					'default'     => __( 'Anders Angstrom', 'power-elements' ),
					'placeholder' => __( 'Your Name Please', 'power-elements' ),
				]
			);
			$this->add_control(
				'peeao_testimonial_address_text',
				[
					'label'       => __( 'Address or Designation', 'power-elements' ),
					'type'        => Controls_Manager::TEXT,
					'default'     => __( 'Happy Client', 'power-elements' ),
					'placeholder' => __( 'Give your designation please.', 'power-elements' ),
					'label_block' => true
				]
			);
			$this->add_control(
				'peeao_testimonial_quote_text',
				[
					'label'       => __( 'Review', 'power-elements' ),
					'type'        => Controls_Manager::TEXTAREA,
					'default'     => __( 'Lorem ipsum dolor sit amet consecteur adipiscing elit sed eiusmod tempor ncididue labor doloremagna aliqua. 
							Ut eniexercitat ullamco laborisnisi ut aliquip commodo consequatduis autes adm irure.
							labor doloremagna aliqua. Ut enim nim veniam qu nostrud', 'power-elements' ),
					'placeholder' => __( 'Give your quote please.', 'power-elements' ),
				]
			);
			$this->add_control(
				'peeao_testimonial_image',
				[
					'label'   => __( 'Choose Image', 'power-elements' ),
					'type'    => Controls_Manager::MEDIA,
					'default' => [
						'url' => \Elementor\Utils::get_placeholder_image_src(),
					],
				]
			);
			$this->add_control(
				'peeao_testimonial_singature_image',
				[
					'label'   => __( 'Choose Signature Image', 'power-elements' ),
					'type'    => Controls_Manager::MEDIA,
					'default' => [
						'url' => \Elementor\Utils::get_placeholder_image_src(),
					],
					'condition' => [
						'peeao_testimonial_style' => 'style_7',
					],
				]
			);
			$this->add_control(
				'peeao_testimonial_ratting',
				[
					'label'   => __( 'Ratting', 'power-elements' ),
					'type'    => Controls_Manager::NUMBER,
					'min'     => 0,
					'max'     => 5,
					'step'    => 0.5,
					'default' => '4.5',
				]
			);
			$this->end_controls_section();
			
			$this->start_controls_section(
				'peeao_testimonial_style_tab',
				[
					'label' => __( 'Testimonial Wrapper', 'power-elements' ),
					'tab'   => Controls_Manager::TAB_STYLE,
				]
			);
			$this->add_responsive_control(
				'peeao_testimonial_align',
				[
					'label'        => __( 'Alignment', 'power-elements' ),
					'type'         => Controls_Manager::CHOOSE,
					'options'      => [
						'left'    => [
							'title' => __( 'Left', 'power-elements' ),
							'icon'  => 'fa fa-align-left',
						],
						'center'  => [
							'title' => __( 'Center', 'power-elements' ),
							'icon'  => 'fa fa-align-center',
						],
						'right'   => [
							'title' => __( 'Right', 'power-elements' ),
							'icon'  => 'fa fa-align-right',
						],
						'justify' => [
							'title' => __( 'Justified', 'power-elements' ),
							'icon'  => 'fa fa-align-justify',
						],
					],
					'default'     => 'center',
					'selectors'  => [
						'{{WRAPPER}} .peeao-wrapper .power_testimonial_item' => 'text-align: {{VALUE}};',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name'     => 'peeao_testimonial_background',
					'label'    => __( 'Background', 'power-elements' ),
					'types'    => [ 'classic', 'gradient', 'video' ],
					'selector' => '{{WRAPPER}} .peeao-wrapper .power_testimonial_item',
				]
			);
			$this->add_control(
				'peeao_testimonial_hr',
				[
					'type' => Controls_Manager::DIVIDER,
				]
			);
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name'     => 'peeao_testimonial_border',
					'label'    => __( 'Border', 'power-elements' ),
					'selector' => '{{WRAPPER}} .peeao-wrapper .power_testimonial_item',
				]
			);
			$this->add_responsive_control(
				'peeao_testimonial_border_radious',
				[
					'label' => esc_html__( 'Border Radius', 'power-elements' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors' => [
						'{{WRAPPER}} .peeao-wrapper .power_testimonial_item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_control(
				'peeao_testimonial_hr-shadow',
				[
					'type' => Controls_Manager::DIVIDER,
				]
			);
			$this->add_group_control(
				Group_Control_Box_Shadow::get_type(),
				[
					'name'     => 'peeao_testimonial_box_shadow',
					'label'    => __( 'Box Shadow', 'power-elements' ),
					'selector' => '{{WRAPPER}} .peeao-wrapper .power_testimonial_item',
				]
			);
			$this->add_control(
				'peeao_testimonial_hr-dimension',
				[
					'type' => Controls_Manager::DIVIDER,
				]
			);
			$this->add_responsive_control(
				'peeao_testimonial_margin',
				[
					'label'      => __( 'Margin', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .peeao-wrapper .power_testimonial_item' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_testimonial_padding',
				[
					'label'      => __( 'Padding', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .peeao-wrapper .power_testimonial_item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_section();
			$this->start_controls_section(
				'peeao_testimonial_style_image_tab',
				[
					'label' => __( 'Testimonial Image', 'power-elements' ),
					'tab'   => Controls_Manager::TAB_STYLE,
				]
			);
			$this->add_responsive_control(
				'peeao_testimonial_width',
				[
					'label'      => __( 'Width', 'power-elements' ),
					'type'       => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%' ],
					'range'      => [
						'px' => [
							'min'  => 0,
							'max'  => 1000,
							'step' => 5,
						],
						'%'  => [
							'min' => 0,
							'max' => 100,
						],
					],
					'default'    => [
						'unit' => 'px',
						'size' => 100,
					],
					'selectors'  => [
						'{{WRAPPER}} .peeao-wrapper .power_testimonial_item .power_testimonial_reviewer_image img' => 'width: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_testimonial_height',
				[
					'label'      => __( 'Height', 'power-elements' ),
					'type'       => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%' ],
					'range'      => [
						'px' => [
							'min'  => 0,
							'max'  => 1000,
							'step' => 5,
						],
						'%'  => [
							'min' => 0,
							'max' => 100,
						],
					],
					'default'    => [
						'unit' => 'px',
						'size' => 100,
					],
					'selectors'  => [
						'{{WRAPPER}} .peeao-wrapper .power_testimonial_item .power_testimonial_reviewer_image img' => 'height: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name'     => 'peeao_testimonial_img_border',
					'label'    => __( 'Border', 'power-elements' ),
					'selector' => '{{WRAPPER}} .peeao-wrapper .power_testimonial_item .power_testimonial_reviewer_image img',
				]
			);
			$this->add_responsive_control(
				'peeao_testimonial_img_radius',
				[
					'label'      => __( 'Border Radius', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .peeao-wrapper .power_testimonial_item .power_testimonial_reviewer_image img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_section();
			$this->start_controls_section(
				'peeao_testimonial_style_content_wrapper_tab',
				[
					'label' => __( 'Content Wrapper', 'power-elements' ),
					'tab'   => Controls_Manager::TAB_STYLE,
				]
			);
			$this->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name'     => 'peeao_testimonial_reviewer_background',
					'label'    => __( 'Background', 'power-elements' ),
					'types'    => [ 'classic', 'gradient'],
					'selector' => '{{WRAPPER}} .peeao-wrapper .power_testimonial_item .power_testimonial_reviewer_content',
				]
			);
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name'     => 'peeao_testimonial_content_wrapper_border',
					'label'    => __( 'Border', 'power-elements' ),
					'selector' => '{{WRAPPER}} .peeao-wrapper .power_testimonial_item .power_testimonial_reviewer_content',
				]
			);
			$this->add_responsive_control(
				'peeao_testimonial_content_wrapper_radius',
				[
					'label'      => __( 'Border Radius', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .peeao-wrapper .power_testimonial_item .power_testimonial_reviewer_content' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_control(
				'peeao_testimonial_hr-content_wrapper_radius',
				[
					'type' => Controls_Manager::DIVIDER,
				]
			);
			$this->add_responsive_control(
				'peeao_testimonial_content_wrapper_margin',
				[
					'label'      => __( 'Margin', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .peeao-wrapper .power_testimonial_item .power_testimonial_reviewer_content' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_testimonial_content_wrapper_padding',
				[
					'label'      => __( 'Padding', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .peeao-wrapper .power_testimonial_item .power_testimonial_reviewer_content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_section();
			/**
			 *
			 * TYPOGRAPHY NAME
			 */
			$this->start_controls_section(
				'peeao_testimonial_style_name_tab',
				[
					'label' => __( 'Name', 'power-elements' ),
					'tab'   => Controls_Manager::TAB_STYLE,
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name'     => 'peeao_testimonial_name_typography',
					'label'    => __( 'Typography', 'power-elements' ),
					'scheme'   => Scheme_Typography::TYPOGRAPHY_1,
					'selector' => '{{WRAPPER}} .peeao-wrapper .power_testimonial_item .power_testimonial_reviewer_name',
				]
			);
			$this->add_control(
				'peeao_testimonial_name_color',
				[
					'label'     => __( 'Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'default'   => '#3284ff',
					'selectors' => [
						'{{WRAPPER}} .peeao-wrapper .power_testimonial_item .power_testimonial_reviewer_name' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Text_Shadow::get_type(),
				[
					'name'     => 'peeao_testimonial_name_text_shadow',
					'label'    => __( 'Text Shadow', 'power-elements' ),
					'selector' => '{{WRAPPER}} .peeao-wrapper .power_testimonial_item .power_testimonial_reviewer_name',
				]
			);
			$this->add_responsive_control(
				'peeao_testimonial_name_margin',
				[
					'label'      => __( 'Margin', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .peeao-wrapper .power_testimonial_item .power_testimonial_reviewer_name' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_testimonial_name_padding',
				[
					'label'      => __( 'Padding', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .peeao-wrapper .power_testimonial_item .power_testimonial_reviewer_name' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_section();
			/**
			 *
			 * TYPEGRAPHY ADDRESS
			 */
			$this->start_controls_section(
				'peeao_testimonial_style_address_tab',
				[
					'label' => __( 'Address', 'power-elements' ),
					'tab'   => Controls_Manager::TAB_STYLE,
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name'     => 'peeao_testimonial_address_typography',
					'label'    => __( 'Typography', 'power-elements' ),
					'scheme'   => Scheme_Typography::TYPOGRAPHY_1,
					'fields_options' => [
						'font_weight' => [
							'default' => '500',
						],
						'font_family' => [
							'default' => 'Poppins',
						],
						'font_size'   => [
							'default' => [ 
								'unit' => 'px', 
								'size' => 12, 
							],
						],
						'text_transform' => [
							'default' => 'uppercase'
						],
					],
					'selector' => '{{WRAPPER}} .peeao-wrapper .power_testimonial_item .power_testimonial_reviewer_company',
				]
			);
			$this->add_control(
				'peeao_testimonial_address_color',
				[
					'label'     => __( 'Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'default'   => '#2f3d53',
					'selectors' => [
						'{{WRAPPER}} .peeao-wrapper .power_testimonial_item .power_testimonial_reviewer_company' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Text_Shadow::get_type(),
				[
					'name'     => 'peeao_testimonial_address_text_shadow',
					'label'    => __( 'Text Shadow', 'power-elements' ),
					'selector' => '{{WRAPPER}} .peeao-wrapper .power_testimonial_item .power_testimonial_reviewer_company',
				]
			);
			$this->add_responsive_control(
				'peeao_testimonial_address_margin',
				[
					'label'      => __( 'Margin', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'default'    => [
						'top' => '5',
						'right' => '0',
						'bottom' => '20',
						'left' => '0',
						'unit' => 'px',
						'isLinked' => '',
					],
					'selectors'  => [
						'{{WRAPPER}} .peeao-wrapper .power_testimonial_item .power_testimonial_reviewer_company' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_testimonial_address_padding',
				[
					'label'      => __( 'Padding', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .peeao-wrapper .power_testimonial_item .power_testimonial_reviewer_company' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_section();
			
			/**
			 *
			 * TYPOGRAPHY QUOTE
			 */
			$this->start_controls_section(
				'peeao_testimonial_style_review_tab',
				[
					'label' => __( 'Review', 'power-elements' ),
					'tab'   => Controls_Manager::TAB_STYLE,
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name'     => 'peeao_testimonial_review_typography',
					'label'    => __( 'Typography', 'power-elements' ),
					'scheme'   => Scheme_Typography::TYPOGRAPHY_1,
					'selector' => '{{WRAPPER}} .peeao-wrapper .power_testimonial_item p.power_testimonial_reviewer_text',
				]
			);
			$this->add_control(
				'peeao_testimonial_review_color',
				[
					'label'     => __( 'Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'default'   => '#222222',
					'selectors' => [
						'{{WRAPPER}} .peeao-wrapper .power_testimonial_item p.power_testimonial_reviewer_text' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Text_Shadow::get_type(),
				[
					'name'     => 'peeao_testimonial_review_shadow',
					'label'    => __( 'Text Shadow', 'power-elements' ),
					'selector' => '{{WRAPPER}} .peeao-wrapper .power_testimonial_item .power_testimonial_reviewer_text',
				]
			);
			$this->add_responsive_control(
				'peeao_testimonial_review_margin',
				[
					'label'      => __( 'Margin', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .peeao-wrapper .power_testimonial_item .power_testimonial_reviewer_text' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_testimonial_review_padding',
				[
					'label'      => __( 'Padding', 'power-elements' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .peeao-wrapper .power_testimonial_item .power_testimonial_reviewer_text' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_section();
			/**
			 *
			 * TYPOGRAPHY ICON
			 */
			$this->start_controls_section(
				'peeao_testimonial_tyle_icon_tab',
				[
					'label' => __( 'Rating', 'power-elements' ),
					'tab'   => Controls_Manager::TAB_STYLE,
				]
			);
			$this->add_control(
				'peeao_testimonial_rating_color',
				[
					'label'     => __( 'Color', 'power-elements' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .peeao-wrapper .power_testimonial_item .power_testimonial_reviewer_rating li' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_responsive_control(
				'peeao_testimonial_rating_size',
				[
					'label'      => __( 'Icon Size', 'power-elements' ),
					'type'       => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%' ],
					'range'      => [
						'px' => [
							'min'  => 5,
							'max'  => 50,
							'step' => 1,
						],
						'%'  => [
							'min' => 1,
							'max' => 50,
						],
					],
					'default'    => [
						'unit' => 'px',
						'size' => 22,
					],
					'selectors'  => [
						'{{WRAPPER}} .peeao-wrapper .power_testimonial_item .power_testimonial_reviewer_rating li' => 'font-size: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_section();
		}
		
		
		/**
		 * Render social widget output on the frontend.
		 *
		 * Written in PHP and used to generate the final HTML.
		 *
		 * @since 1.0.0
		 * @access protected
		 */
		protected function render() {
			$settings = $this->get_settings(); 
			echo '<div class="peeao-wrapper">';
			if ( $settings['peeao_testimonial_image']['url'] != '' ) {
				if ( in_array( $settings['peeao_testimonial_style'], array( 'style_4', 'style_5', 'style_6', 'style_7', 'style_8' ) ) ) {
					$img = '<div class="power_testimonial_reviewer_image">
                        <img src="' . $settings['peeao_testimonial_image']['url'] . '" alt="' . esc_attr( $settings['peeao_testimonial_name_text'] ) . '">
                    </div>';
				} else {
					$img = '<div class="power_testimonial_reviewer_meta_inner">
						<div class="power_testimonial_reviewer_image">
							<img src="' . $settings['peeao_testimonial_image']['url'] . '" alt="' . esc_attr( $settings['peeao_testimonial_name_text'] ) . '">
						</div>
					</div>';
				}
			} else {
				$img = '';
			}

			if ( $settings['peeao_testimonial_singature_image']['url'] != '' ) {
				$singature_image = '<img src="' . $settings['peeao_testimonial_singature_image']['url'] . '" alt="' . esc_attr( $settings['peeao_testimonial_name_text'] ) . '">';
			} else {
				$singature_image = '';
			}
			
			if ( $settings['peeao_testimonial_ratting'] ) {
				$ratting = Partials::get_rating_html( $settings['peeao_testimonial_ratting'] );
			} else {
				$ratting = '';
			}


			if ($settings['peeao_testimonial_quote_image']['url'] != '') {
				$quote_image = '<div class="power_testimonial_quote_image">
							<img src="' . $settings['peeao_testimonial_quote_image']['url'] . '" >
						</div>';
			} else {
				$quote_image = '';
			}
			$watermark_class = ( $settings['peeao_testimonial_quote_watermark'] == '1' ) ? 'power_testimonial_quote_watermark' : '';

			if ( $settings['peeao_testimonial_style'] == 'style_2' ) {
				echo '<div class="power_testimonial_item">
               ' . $img . '
                <div class="power_testimonial_reviewer_content '.esc_attr($watermark_class).'">
                    <div class="power_testimonial_reviewer_details">
                        <h4 class="power_testimonial_reviewer_name">' . Utils::kses( $settings['peeao_testimonial_name_text'] ) . '</h4>
                        <h6 class="power_testimonial_reviewer_company">' . Utils::kses( $settings['peeao_testimonial_address_text'] ) . '</h6>
                    </div>
                    <p class="power_testimonial_reviewer_text">' . Utils::kses( $settings['peeao_testimonial_quote_text'] ) . '</p>
                  ' . $ratting . '
                </div>
            </div>';
			} elseif ( $settings['peeao_testimonial_style'] == 'style_3' ) {
				echo '<div class="power_testimonial_item">
                <div class="power_testimonial_reviewer_content '.esc_attr($watermark_class).'">
                    <div class="power_testimonial_reviewer_details">
                        <h4 class="power_testimonial_reviewer_name">' . Utils::kses( $settings['peeao_testimonial_name_text'] ) . '</h4>
                        <h6 class="power_testimonial_reviewer_company">' . Utils::kses( $settings['peeao_testimonial_address_text'] ) . '</h6>
                    </div>
                    <p class="power_testimonial_reviewer_text">' . Utils::kses( $settings['peeao_testimonial_quote_text'] ) . '</p>
                   ' . $ratting . '
                </div>
                ' . $img . '
            </div>';
			} elseif ( $settings['peeao_testimonial_style'] == 'style_4' ) {
				echo '<div class="power_testimonial_item power_testimonial_reviewer_image_aside">
                <div class="power_testimonial_reviewer_content '.esc_attr($watermark_class).'">
                     <p class="power_testimonial_reviewer_text">' . Utils::kses( $settings['peeao_testimonial_quote_text'] ) . '</p>
                    ' . $ratting . '
                </div>
                <div class="power_testimonial_reviewer_meta_inner">
                    ' . $img . '
                    <div class="power_testimonial_reviewer_details">
                        <h4 class="power_testimonial_reviewer_name">' . Utils::kses( $settings['peeao_testimonial_name_text'] ) . '</h4>
                        <h6 class="power_testimonial_reviewer_company">' . Utils::kses( $settings['peeao_testimonial_address_text'] ) . '</h6>
                    </div>
                </div>
            </div>';
			} elseif ( $settings['peeao_testimonial_style'] == 'style_5' ) {
				echo '<div class="power_testimonial_item power_testimonial_reviewer_image_aside">
                <div class="power_testimonial_reviewer_meta_inner">
                    ' . $img . '
                    <div class="power_testimonial_reviewer_details">
                       <h4 class="power_testimonial_reviewer_name">' . Utils::kses( $settings['peeao_testimonial_name_text'] ) . '</h4>
                       <h6 class="power_testimonial_reviewer_company">' . Utils::kses( $settings['peeao_testimonial_address_text'] ) . '</h6>
                    </div>
                </div>
                <div class="power_testimonial_reviewer_content '.esc_attr($watermark_class).'">
                    <p class="power_testimonial_reviewer_text">' . Utils::kses( $settings['peeao_testimonial_quote_text'] ) . '</p>
                   ' . $ratting . '
                </div>
            </div>';
			}elseif ($settings['peeao_testimonial_style'] == 'style_6'){
			    echo '<div class="power_testimonial_item power_testimonial_reviewer_image_aside">
						<div class="power_testimonial_reviewer_meta_inner">
							'.$img.'
							<div class="power_testimonial_reviewer_details">
								<div class="power_testimonial_reviewer_content '.esc_attr($watermark_class).'">
									<h4 class="power_testimonial_reviewer_name">' . Utils::kses( $settings['peeao_testimonial_name_text'] ) . '</h4>
									<h6 class="power_testimonial_reviewer_company">' . Utils::kses( $settings['peeao_testimonial_address_text'] ) . '</h6>
									<p class="power_testimonial_reviewer_text">' . Utils::kses( $settings['peeao_testimonial_quote_text'] ) . '</p>
								'.$ratting.'
								</div>
							</div>
						</div>
					</div>';
            }elseif ($settings['peeao_testimonial_style'] == 'style_7'){
				echo '<div class="type_7 power_testimonial_item">
					<div class="power_testimonial_reviewer_meta_inner">
						<div class="power_testimonial_reviewer_details">
							<h4 class="power_testimonial_reviewer_name">' . Utils::kses( $settings['peeao_testimonial_name_text'] ) . '</h4>
							<h6 class="power_testimonial_reviewer_company">' . Utils::kses( $settings['peeao_testimonial_address_text'] ) . '</h6>
						</div>
						' . $img . '
						<div class="power_testimonial_reviewer_content '.esc_attr($watermark_class).'">
							<p class="power_testimonial_reviewer_text">' . Utils::kses( $settings['peeao_testimonial_quote_text'] ) . '</p>    
							' . $singature_image . '
						</div>
					</div>
				</div>';
			}elseif ($settings['peeao_testimonial_style'] == 'style_8'){
			    echo '<div class="power_testimonial_item power_testimonial_reviewer_image_aside">
						<div class="power_testimonial_reviewer_meta_inner">
							'.$img.'
							<div class="power_testimonial_reviewer_details">
								<div class="power_testimonial_reviewer_content '.esc_attr($watermark_class).'">
									'.$ratting.'
									<p class="power_testimonial_reviewer_text">' . Utils::kses( $settings['peeao_testimonial_quote_text'] ) . '</p>
									<h4 class="power_testimonial_reviewer_name">' . Utils::kses( $settings['peeao_testimonial_name_text'] ) . '</h4>
									<h6 class="power_testimonial_reviewer_company">' . Utils::kses( $settings['peeao_testimonial_address_text'] ) . '</h6>
								</div>
							</div>
						</div>
					</div>';
            }elseif ($settings['peeao_testimonial_style'] == 'style_9'){
			    echo '<div class="power_testimonial_item">
						<div class="power_testimonial_reviewer_meta_inner">
							'.$quote_image.'
							<div class="power_testimonial_reviewer_details">
								<div class="power_testimonial_reviewer_content '.esc_attr($watermark_class).'">
									<p class="power_testimonial_reviewer_text">' . Utils::kses( $settings['peeao_testimonial_quote_text'] ) . '</p>
								</div>
							</div>
						</div>
					</div>';
            } else {
				echo '<div class="power_testimonial_item">
                ' . $img . '
                <div class="power_testimonial_reviewer_content '.esc_attr($watermark_class).'">
                    ' . $ratting . '
                    <p class="power_testimonial_reviewer_text">' . Utils::kses( $settings['peeao_testimonial_quote_text'] ) . '</p>
                    <div class="power_testimonial_reviewer_details">
                        <h4 class="power_testimonial_reviewer_name">' . Utils::kses( $settings['peeao_testimonial_name_text'] ) . '</h4>
                        <h6 class="power_testimonial_reviewer_company">' . Utils::kses( $settings['peeao_testimonial_address_text'] ) . '</h6>
                    </div>
                </div>
				</div>';
			}
			echo '</div>';
		}
		
		/**
		 * Render social widget output in the editor.
		 *
		 * Written as a Backbone JavaScript template and used to generate the live preview.
		 *
		 * @since 1.0.0
		 * @access protected
		 */
		protected function _content_template() {}
	}