<?php

namespace PowerElements;

use PowerElements\Helpers\Partials as Partials;

use \Elementor\Repeater;
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Text_Shadow;


if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly.
}

/**
 * Power Element social widget.
 *
 * Elementor widget that displays a social with the ability to control every
 * aspect of the social design.
 *
 * @since 1.0.0
 */
class PowerElements_Testimonial_Carousel extends Widget_Base
{

	/**
	 * Get widget name.
	 *
	 * Retrieve social widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name()
	{
		return 'power_elements_testimonial_carousel';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve social widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title()
	{
		return __('Testimonial Carousel', 'power-elements');
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve social widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon()
	{
		return 'eicon-testimonial';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the social widget belongs to.
	 *
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since 2.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories()
	{
		return ['power-elements'];
	}


	/**
	 * Register social widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function _register_controls()
	{
		$this->start_controls_section(
			'peeao_testimonial_carousel_content_tab',
			[
				'label' => __('Testimonial Content', 'power-elements'),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'peeao_testimonial_carousel_style',
			[
				'label'   => __('Style', 'power-elements'),
				'type'    => Controls_Manager::SELECT,
				'default' => 'style_2',
				'options' => [
					'style_1' => __('Style 1', 'power-elements'),
					'style_2' => __('Style 2', 'power-elements'),
					'style_3' => __('Style 3', 'power-elements'),
					'style_4' => __('Style 4', 'power-elements'),
					'style_5' => __('Style 5', 'power-elements'),
					'style_6' => __('Style 6', 'power-elements'),
					'style_7' => __('Style 7', 'power-elements'),
					'style_8' => __('Style 8', 'power-elements'),
					'style_9' => __('Style 9', 'power-elements'),
					'style_10' => __('Style 10', 'power-elements')
				]
			]
		);
		$this->add_control(
			'peeao_testimonial_carousel_quote_image',
			[
				'label'   => __('Choose Quote Image', 'power-elements'),
				'type'    => Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
				'condition' => [
					'peeao_testimonial_carousel_style' => 'style_10',
				]
			]
		); 
		$this->add_control(
			'peeao_testimonial_carousel_quote_watermark',
			[
				'label'   => __('Use Watermark Quote', 'power-elements'),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'1' => [
						'title' => __('Yes', 'power-elements'),
						'icon'  => 'fa fa-check',
					],
					'0' => [
						'title' => __('No', 'power-elements'),
						'icon'  => 'fa fa-ban',
					],
				],
				'default' => '1',
			]
		);
		$repeater = new Repeater();
		$repeater->add_control(
			'name_text',
			[
				'label'       => __('Name', 'power-elements'),
				'type'        => Controls_Manager::TEXT,
				'default'     => __('Anders Angstrom', 'power-elements'),
				'placeholder' => __('Your Name Please', 'power-elements'),
			]
		);
		$repeater->add_control(
			'address_text',
			[
				'label'       => __('Address or Designation', 'power-elements'),
				'type'        => Controls_Manager::TEXT,
				'default'     => __('Happy Client', 'power-elements'),
				'placeholder' => __('Give your designation please.', 'power-elements'),
				'label_block' => true
			]
		);
		$repeater->add_control(
			'review_text',
			[
				'label'       => __('Review', 'power-elements'),
				'type'        => Controls_Manager::TEXTAREA,
				'default'     => __('Lorem ipsum dolor sit amet consecteur adipiscing elit sed eiusmod tempor ncididue labor doloremagna aliqua. 
					Ut eniexercitat ullamco laborisnisi ut aliquip commodo consequatduis autes adm irure.
					labor doloremagna aliqua. Ut enim nim veniam qu nostrud', 'power-elements'),
				'placeholder' => __('Give your quote please.', 'power-elements'),
			]
		);
		$repeater->add_control(
			'peeao_testimonial_carousel_image',
			[
				'label'   => __('Choose Image', 'power-elements'),
				'type'    => Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
		$repeater->add_control(
			'peeao_testimonial_carousel_ratting',
			[
				'label'   => __('Ratting', 'power-elements'),
				'type'    => Controls_Manager::NUMBER,
				'min'     => 0,
				'max'     => 5,
				'step'    => 0.5,
				'default' => '',
			]
		);
		$this->add_control(
			'peeao_testimonial_carousel_list',
			[
				'label'       => __('Testimonial List', 'power-elements'),
				'type'        => Controls_Manager::REPEATER,
				'fields'      => $repeater->get_controls(),
				'default'     => [
					[
						'name_text'   => __('Anders Angstrom', 'power-elements'),
						'address_text' => __('Happy Client', 'power-elements'),
						'review_text' => __('Lorem ipsum dolor sit amet consecteur adipiscing elit sed eiusmod tempor ncididue labor doloremagna aliqua. 
							Ut eniexercitat ullamco laborisnisi ut aliquip commodo consequatduis autes adm irure.
							labor doloremagna aliqua. Ut enim nim veniam qu nostrud', 'power-elements'),
					],
					[
						'name_text'   => __('Anders Angstrom', 'power-elements'),
						'address_text' => __('Happy Client', 'power-elements'),
						'review_text' => __('Lorem ipsum dolor sit amet consecteur adipiscing elit sed eiusmod tempor ncididue labor doloremagna aliqua. 
							Ut eniexercitat ullamco laborisnisi ut aliquip commodo consequatduis autes adm irure.
							labor doloremagna aliqua. Ut enim nim veniam qu nostrud', 'power-elements'),
					],
					[
						'name_text'   => __('Anders Angstrom', 'power-elements'),
						'address_text' => __('Happy Client', 'power-elements'),
						'review_text' => __('Lorem ipsum dolor sit amet consecteur adipiscing elit sed eiusmod tempor ncididue labor doloremagna aliqua. 
							Ut eniexercitat ullamco laborisnisi ut aliquip commodo consequatduis autes adm irure.
							labor doloremagna aliqua. Ut enim nim veniam qu nostrud', 'power-elements'),
					],
				],
				'title_field' => '{{{ name_text }}}',
			]
		);
		$this->end_controls_section();
		/*
			 * CAROUSEL SETTINGS
			 */
		$this->start_controls_section(
			'peeao_testimonial_carousel_section_settings_tab',
			[
				'label' => __('Settings', 'power-elements'),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'peeao_testimonial_carousel_item',
			[
				'label'       => __('Desktop Item', 'power-elements'),
				'type'        => Controls_Manager::NUMBER,
				'min'         => 1,
				'max'         => 5,
				'step'        => 1,
				'default'     => 1,
				'description' => __('Number of item shows on destop and tablet screen', 'power-elements'),
			]
		);
		$this->add_control(
			'peeao_testimonial_carousel_item_mobile',
			[
				'label'       => __('Mobile Item', 'power-elements'),
				'type'        => Controls_Manager::NUMBER,
				'min'         => 1,
				'max'         => 5,
				'step'        => 1,
				'default'     => 1,
				'description' => __('Number of item shows on mobile and small tablet screen', 'power-elements'),
			]
		);
		$this->add_responsive_control(
			'peeao_testimonial_carousel_margin',
			[
				'label'   => __('Margin', 'power-elements'),
				'type'    => Controls_Manager::SLIDER,
				'range'   => [
					'min'  => 0,
					'max'  => 1000,
					'step' => 5,
				],
				'default' => [
					'size' => 30,
				],
			]
		);
		$this->add_responsive_control(
			'peeao_testimonial_carousel_padding',
			[
				'label'   => __('Padding', 'power-elements'),
				'type'    => Controls_Manager::SLIDER,
				'range'   => [
					'min'  => 0,
					'max'  => 1000,
					'step' => 5,
				],
				'default' => [
					'size' => 30,
				],
			]
		);
		$this->add_control(
			'peeao_testimonial_carousel_autoplay',
			[
				'label'   => __('Autoplay', 'power-elements'),
				'type'    => Controls_Manager::SELECT,
				'default' => 'false',
				'options' => [
					'true'  => __('True', 'power-elements'),
					'false' => __('False', 'power-elements'),
				],
			]
		);
		$this->add_control(
			'peeao_testimonial_carousel_responsive_class',
			[
				'label'   => __('Responsive Class', 'power-elements'),
				'type'    => Controls_Manager::SELECT,
				'default' => 'false',
				'options' => [
					'true'  => __('True', 'power-elements'),
					'false' => __('False', 'power-elements'),
				],
			]
		);
		$this->add_control(
			'peeao_testimonial_carousel_dots',
			[
				'label'   => __('Dots', 'power-elements'),
				'type'    => Controls_Manager::SELECT,
				'default' => 'false',
				'options' => [
					'true'  => __('True', 'power-elements'),
					'false' => __('False', 'power-elements'),
				],
			]
		);
		$this->add_control(
			'peeao_testimonial_carousel_nav',
			[
				'label'   => __('Navigation', 'power-elements'),
				'type'    => Controls_Manager::SELECT,
				'default' => 'false',
				'options' => [
					'true'  => __('True', 'power-elements'),
					'false' => __('False', 'power-elements'),
				],
			]
		);
		$this->add_control(
			'peeao_testimonial_carousel_nav_style',
			[
				'label'   => __('Navigation Position', 'power-elements'),
				'type'    => Controls_Manager::SELECT,
				'default' => 'power_owl_nav_bottom',
				'options' => [
					'power_owl_nav_bottom'  => __('Bottom', 'power-elements'),
					'power_owl_nav_side' => __('Side', 'power-elements'),
				],
				'condition'   => [
					'peeao_testimonial_carousel_nav' => 'true',
				],
			]
		);
		$this->end_controls_section();
		/*
			 * STYLE
			 */
		$this->start_controls_section(
			'peeao_testimonial_carousel_style_tab',
			[
				'label' => __('Testimonial Wrapper', 'power-elements'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_responsive_control(
			'peeao_testimonial_carousel_align',
			[
				'label'        => __('Alignment', 'power-elements'),
				'type'         => Controls_Manager::CHOOSE,
				'options'      => [
					'left'    => [
						'title' => __('Left', 'power-elements'),
						'icon'  => 'fa fa-align-left',
					],
					'center'  => [
						'title' => __('Center', 'power-elements'),
						'icon'  => 'fa fa-align-center',
					],
					'right'   => [
						'title' => __('Right', 'power-elements'),
						'icon'  => 'fa fa-align-right',
					],
					'justify' => [
						'title' => __('Justified', 'power-elements'),
						'icon'  => 'fa fa-align-justify',
					],
				],
				'default' => 'center',
				'selectors'  => [
					'{{WRAPPER}} .power_testimonial_carousel_item' => 'text-align: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name'     => 'peeao_testimonial_carousel_background',
				'label'    => __('Background', 'power-elements'),
				'types'    => ['classic', 'gradient', 'video'],
				'selector' => '{{WRAPPER}} .power_testimonial_carousel_item',
			]
		);
		$this->add_control(
			'hr',
			[
				'type' => Controls_Manager::DIVIDER,
			]
		);
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'     => 'peeao_testimonial_carousel_border',
				'label'    => __('Border', 'power-elements'),
				'selector' => '{{WRAPPER}} .power_testimonial_carousel_item',
			]
		);
		$this->add_responsive_control(
			'peeao_testimonial_carousel_border_radious',
			[
				'label' => esc_html__('Border Radius', 'power-elements'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors' => [
					'{{WRAPPER}} .power_testimonial_carousel_item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
			'peeao_testimonial_carousel_hr-shadow',
			[
				'type' => Controls_Manager::DIVIDER,
			]
		);
		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'peeao_testimonial_carousel_box_shadow',
				'label'    => __('Box Shadow', 'power-elements'),
				'selector' => '{{WRAPPER}} .power_testimonial_carousel_item',
			]
		);
		$this->add_control(
			'peeao_testimonial_carousel_hr-dimension',
			[
				'type' => Controls_Manager::DIVIDER,
			]
		);
		$this->add_responsive_control(
			'peeao_testimonial_carousel_item_margin',
			[
				'label'      => __('Margin', 'power-elements'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors'  => [
					'{{WRAPPER}} .power_testimonial_carousel_item' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'peeao_testimonial_carousel_item_padding',
			[
				'label'      => __('Padding', 'power-elements'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors'  => [
					'{{WRAPPER}} .power_testimonial_carousel_item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'peeao_testimonial_carousel_style_image_tab',
			[
				'label' => __('Testimonial Image', 'power-elements'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
            'peeao_testimonial_carousel_style_image_alignment',
            [
                'label'     => esc_html__( 'Vertical Alignment', 'power-elements' ),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'middle',
                'options'   => [
					'middle'     => esc_html__( 'Middle', 'power-elements' ),
					'top'     => esc_html__( 'Top', 'power-elements' ),
					'bottom'     => esc_html__( 'Bottom', 'power-elements' ),
				],
				'condition' => [
					'peeao_testimonial_carousel_style' => ['style_6', 'style_9'],
				],
				'selectors'  => [
					'{{WRAPPER}} .power_testimonial_carousel_item .power_testimonial_carousel_reviewer_image' => 'vertical-align: {{VALUE}};',
				],
            ]
        );
		$this->add_responsive_control(
			'peeao_testimonial_carousel_width',
			[
				'label'      => __('Width', 'power-elements'),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => ['px', '%'],
				'range'      => [
					'px' => [
						'min'  => 0,
						'max'  => 1000,
						'step' => 5,
					],
					'%'  => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default'    => [
					'unit' => 'px',
					'size' => 100,
				],
				'selectors'  => [
					'{{WRAPPER}} .power_testimonial_carousel_item .power_testimonial_carousel_reviewer_image img' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'peeao_testimonial_carousel_height',
			[
				'label'      => __('Height', 'power-elements'),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => ['px', '%'],
				'range'      => [
					'px' => [
						'min'  => 0,
						'max'  => 1000,
						'step' => 5,
					],
					'%'  => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default'    => [
					'unit' => 'px',
					'size' => 100,
				],
				'selectors'  => [
					'{{WRAPPER}} .power_testimonial_carousel_item .power_testimonial_carousel_reviewer_image img' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'     => 'peeao_testimonial_carousel_img_border',
				'label'    => __('Border', 'power-elements'),
				'selector' => '{{WRAPPER}} .power_testimonial_carousel_item .power_testimonial_carousel_reviewer_image img',
			]
		);
		$this->add_responsive_control(
			'peeao_testimonial_carousel_radius',
			[
				'label'      => __('Border Radius', 'power-elements'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors'  => [
					'{{WRAPPER}} .power_testimonial_carousel_item .power_testimonial_carousel_reviewer_image img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'peeao_testimonial_img_margin',
			[
				'label'      => __('Margin', 'power-elements'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors'  => [
					'{{WRAPPER}} .power_testimonial_carousel_item .power_testimonial_carousel_reviewer_image' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'peeao_testimonial_img_padding',
			[
				'label'      => __('Padding', 'power-elements'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors'  => [
					'{{WRAPPER}} .power_testimonial_carousel_item .power_testimonial_carousel_reviewer_image' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'peeao_testimonial_carousel_style_content_wrapper_tab',
			[
				'label' => __('Content Wrapper', 'power-elements'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name'     => 'peeao_testimonial_carousel_content_wrapper_background',
				'label'    => __('Background', 'power-elements'),
				'types'    => ['classic', 'gradient'],
				'selector' => '{{WRAPPER}} .power_testimonial_carousel_item .power_testimonial_carousel_reviewer_content',
			]
		);
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name'     => 'peeao_testimonial_carousel_content_wrapper_symbol',
				'label'    => __('Symbol/Icon', 'power-elements'),
				'types'    => ['classic'],
				'selector' => '{{WRAPPER}} .power_testimonial_carousel_item .power_testimonial_carousel_reviewer_content:before',
			]
		);
		$this->add_control(
			'peeao_testimonial_carousel_hr-quote_wrapper_radius',
			[
				'type' => Controls_Manager::DIVIDER,
			]
		);
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'     => 'peeao_testimonial_carousel_content_wrapper_border',
				'label'    => __('Border', 'power-elements'),
				'selector' => '{{WRAPPER}} .power_testimonial_carousel_item .power_testimonial_carousel_reviewer_content',
			]
		);
		$this->add_responsive_control(
			'peeao_testimonial_carousel_content_wrapper_radius',
			[
				'label'      => __('Border Radius', 'power-elements'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors'  => [
					'{{WRAPPER}} .power_testimonial_carousel_item .power_testimonial_carousel_reviewer_content' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'peeao_testimonial_carousel_content_wrapper_box_shadow',
				'label'    => __('Box Shadow', 'power-elements'),
				'selector' => '{{WRAPPER}} .power_testimonial_carousel_item .power_testimonial_carousel_reviewer_content',
			]
		);
		$this->add_control(
			'peeao_testimonial_carousel_content_wrapper_hr',
			[
				'type' => Controls_Manager::DIVIDER,
			]
		);
		$this->add_responsive_control(
			'peeao_testimonial_carousel_content_wrapper_margin',
			[
				'label'      => __('Margin', 'power-elements'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors'  => [
					'{{WRAPPER}} .power_testimonial_carousel_item .power_testimonial_carousel_reviewer_content' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'peeao_testimonial_carousel_content_wrapper_padding',
			[
				'label'      => __('Padding', 'power-elements'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors'  => [
					'{{WRAPPER}} .power_testimonial_carousel_item .power_testimonial_carousel_reviewer_content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);


		$this->add_control(
			'peeao_testimonial_carousel_content_wrapper_arrow',
			[
				'label' => esc_html__('Arrow Color', 'power-elements'),
				'type' =>  Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .type_7.power_testimonial_carousel_item .power_testimonial_carousel_reviewer_content:after' => 'border-top-color: {{VALUE}};',
				],
				'condition' => [
					'peeao_testimonial_carousel_style' => 'style_7',
				]
			]
		);
		$this->end_controls_section();
		/**
		 *
		 * TYPOGRAPHY NAME
		 */
		$this->start_controls_section(
			'peeao_testimonial_carousel_style_name_tab',
			[
				'label' => __('Name', 'power-elements'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'peeao_testimonial_carousel_name_typography',
				'label'    => __('Typography', 'power-elements'),
				'selector' => '{{WRAPPER}} .power_testimonial_carousel_item .power_testimonial_carousel_reviewer_name',
			]
		);
		$this->add_control(
			'peeao_testimonial_carousel_name_color',
			[
				'label'     => __('Color', 'power-elements'),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#3284ff',
				'selectors' => [
					'{{WRAPPER}} .power_testimonial_carousel_item .power_testimonial_carousel_reviewer_name' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Text_Shadow::get_type(),
			[
				'name'     => 'peeao_testimonial_carousel_name_text_shadow',
				'label'    => __('Text Shadow', 'power-elements'),
				'selector' => '{{WRAPPER}} .power_testimonial_carousel_item .power_testimonial_carousel_reviewer_name',
			]
		);
		$this->add_responsive_control(
			'peeao_testimonial_carousel_name_margin',
			[
				'label'      => __('Margin', 'power-elements'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors'  => [
					'{{WRAPPER}} .power_testimonial_carousel_item .power_testimonial_carousel_reviewer_name' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'peeao_testimonial_carousel_name_padding',
			[
				'label'      => __('Padding', 'power-elements'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors'  => [
					'{{WRAPPER}} .power_testimonial_carousel_item .power_testimonial_carousel_reviewer_name' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();
		/**
		 *
		 * TYPEGRAPHY ADDRESS
		 */
		$this->start_controls_section(
			'peeao_testimonial_carousel_style_address_tab',
			[
				'label' => __('Address', 'power-elements'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'peeao_testimonial_carousel_address_typography',
				'label'    => __('Typography', 'power-elements'),
				'selector' => '{{WRAPPER}} .power_testimonial_carousel_item .power_testimonial_carousel_reviewer_company',
			]
		);
		$this->add_control(
			'peeao_testimonial_carousel_address_color',
			[
				'label'     => __('Color', 'power-elements'),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#999999',
				'selectors' => [
					'{{WRAPPER}} .power_testimonial_carousel_item .power_testimonial_carousel_reviewer_company' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Text_Shadow::get_type(),
			[
				'name'     => 'peeao_testimonial_carousel_address_text_shadow',
				'label'    => __('Text Shadow', 'power-elements'),
				'selector' => '{{WRAPPER}} .power_testimonial_carousel_item .power_testimonial_carousel_reviewer_company',
			]
		);
		$this->add_responsive_control(
			'peeao_testimonial_carousel_address_margin',
			[
				'label'      => __('Margin', 'power-elements'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'default'    => [
					'top' => '5',
					'right' => '0',
					'bottom' => '20',
					'left' => '0',
					'unit' => 'px',
					'isLinked' => '',
				],
				'selectors'  => [
					'{{WRAPPER}} .power_testimonial_carousel_item .power_testimonial_carousel_reviewer_company' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'peeao_testimonial_carousel_address_padding',
			[
				'label'      => __('Padding', 'power-elements'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors'  => [
					'{{WRAPPER}} .power_testimonial_carousel_item .power_testimonial_carousel_reviewer_company' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();

		/**
		 *
		 * TYPOGRAPHY QUOTE
		 */
		$this->start_controls_section(
			'peeao_testimonial_carousel_style_review_tab',
			[
				'label' => __('Review', 'power-elements'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'peeao_testimonial_carousel_review_typography',
				'label'    => __('Typography', 'power-elements'),
				'selector' => '{{WRAPPER}} .power_testimonial_carousel_item .power_testimonial_carousel_reviewer_text',
			]
		);
		$this->add_control(
			'peeao_testimonial_carousel_review_color',
			[
				'label'     => __('Color', 'power-elements'),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#222222',
				'selectors' => [
					'{{WRAPPER}} .power_testimonial_carousel_item .power_testimonial_carousel_reviewer_text' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Text_Shadow::get_type(),
			[
				'name'     => 'peeao_testimonial_carousel_review_text_shadow',
				'label'    => __('Text Shadow', 'power-elements'),
				'selector' => '{{WRAPPER}} .power_testimonial_carousel_item .power_testimonial_carousel_reviewer_text',
			]
		);
		$this->add_responsive_control(
			'peeao_testimonial_carousel_review_margin',
			[
				'label'      => __('Margin', 'power-elements'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors'  => [
					'{{WRAPPER}} .power_testimonial_carousel_item .power_testimonial_carousel_reviewer_text' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'peeao_testimonial_carousel_review_padding',
			[
				'label'      => __('Padding', 'power-elements'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors'  => [
					'{{WRAPPER}} .power_testimonial_carousel_item .power_testimonial_carousel_reviewer_text' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();
		/**
		 *
		 * TYPOGRAPHY ICON
		 */
		$this->start_controls_section(
			'peeao_testimonial_carousel_style_rating_tab',
			[
				'label' => __('Rating', 'power-elements'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'peeao_testimonial_carousel_rating_color',
			[
				'label'     => __('Color', 'power-elements'),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .power_testimonial_carousel_item .power_testimonial_reviewer_rating li' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_responsive_control(
			'peeao_testimonial_carousel_rating_size',
			[
				'label'      => __('Icon Size', 'power-elements'),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => ['px', '%'],
				'range'      => [
					'px' => [
						'min'  => 5,
						'max'  => 50,
						'step' => 1,
					],
					'%'  => [
						'min' => 1,
						'max' => 50,
					],
				],
				'default'    => [
					'unit' => 'px',
					'size' => 22,
				],
				'selectors'  => [
					'{{WRAPPER}} .power_testimonial_carousel_item .power_testimonial_reviewer_rating li' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'peeao_testimonial_carousel_rating_padding',
			[
				'label'      => __('Padding', 'power-elements'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors'  => [
					'{{WRAPPER}} .peeao-wrapper .power_testimonialcarousel  .power_testimonial_reviewer_rating' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
				],
			]
		);
		$this->add_responsive_control(
			'peeao_testimonial_carousel_rating_margin',
			[
				'label'      => __('Margin', 'power-elements'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors'  => [
					'{{WRAPPER}} .peeao-wrapper .power_testimonialcarousel  .power_testimonial_reviewer_rating' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
				],
			]
		);
		$this->end_controls_section();


		/*
			 * NAV Style
			 */
		$this->start_controls_section(
			'peeao_testimonial_carousel_nav_style_tab',
			[
				'label'     => __('Nav', 'power-elements'),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => [
					'peeao_testimonial_carousel_nav' => 'true',
				],
			]
		);

		$this->add_responsive_control(
			'peeao_testimonial_carousel_nav_align',
			[
				'label'     => __('Alignment', 'power-elements'),
				'type'      => Controls_Manager::CHOOSE,
				'options'   => [
					'left'    => [
						'title' => __('Left', 'power-elements'),
						'icon'  => 'fa fa-align-left',
					],
					'center'  => [
						'title' => __('Center', 'power-elements'),
						'icon'  => 'fa fa-align-center',
					],
					'right'   => [
						'title' => __('Right', 'power-elements'),
						'icon'  => 'fa fa-align-right',
					],
					'justify' => [
						'title' => __('Justified', 'power-elements'),
						'icon'  => 'fa fa-align-justify',
					],
				],
				'default'  => 'center',
				'selectors' => [
					'{{WRAPPER}} .peeao-wrapper .power_testimonialcarousel  .owl-nav' => 'text-align: {{VALUE}};',
				],
				'condition'   => [
					'peeao_testimonial_carousel_nav_style' => 'power_owl_nav_bottom',
				],
			]
		);
		$this->add_responsive_control(
			'peeao_testimonial_carousel_nav_size',
			[
				'label'   => __('Arrow Size', 'power-elements'),
				'type'    => Controls_Manager::SLIDER,
				'size_units' => ['px', 'em'],
				'range'   => [
					'min'  => 0,
					'max'  => 200,
					'step' => 1,
				],
				'default' => [
					'size' => 30,
					'unit' => 'px',
				],
				'selectors' => [
					'{{WRAPPER}} .peeao-wrapper .power_testimonialcarousel.owl-theme .owl-nav [class*=\'owl-\']' => 'font-size: {{SIZE}}{{UNIT}}; line-height: {{SIZE}}{{UNIT}} ',
				],
			]
		);
		$this->add_responsive_control(
			'peeao_testimonial_carousel_nav_prev_spacing',
			[
				'label'   => __('Previous arrow spacing', 'power-elements'),
				'type'    => Controls_Manager::SLIDER,
				'size_units' => ['px', '%'],
				'range'   => [
					'min'  => 0,
					'max'  => 200,
					'step' => 1,
				],
				'default' => [
					'size' => 50,
				],
				'selectors' => [
					'{{WRAPPER}} .peeao-wrapper .power_testimonialcarousel  .owl-nav .owl-prev' => 'left: -{{SIZE}}{{UNIT}}',
				],
			]
		);
		$this->add_responsive_control(
			'peeao_testimonial_carousel_nav_next_spacing',
			[
				'label'   => __('Next arrow spacing', 'power-elements'),
				'type'    => Controls_Manager::SLIDER,
				'size_units' => ['px', '%'],
				'range'   => [
					'min'  => 0,
					'max'  => 200,
					'step' => 1,
				],
				'default' => [
					'size' => 50,
				],
				'selectors' => [
					'{{WRAPPER}} .peeao-wrapper .power_testimonialcarousel  .owl-nav .owl-next' => 'right: -{{SIZE}}{{UNIT}}',
				],
			]
		);
		$this->start_controls_tabs(
			'peeao_testimonial_carousel_nav_tabs'
		);

		$this->start_controls_tab(
			'peeao_testimonial_carousel_nav_normal_tab',
			[
				'label' => __('Normal', 'power-elements'),
			]
		);
		$this->add_control(
			'peeao_testimonial_carousel_nav_color',
			[
				'label'     => __('Color', 'power-elements'),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .peeao-wrapper .power_testimonialcarousel  .owl-nav .owl-prev' => 'color: {{VALUE}}',
					'{{WRAPPER}} .peeao-wrapper .power_testimonialcarousel  .owl-nav .owl-next' => 'color: {{VALUE}}',
					'{{WRAPPER}} .power_outside_grid_owl_prev, .power_outside_grid_owl_next' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name'     => 'peeao_testimonial_carousel_nav_bg_color',
				'label'    => __('Background Color', 'power-elements'),
				'types'    => ['classic', 'gradient'],
				'selector' => '{{WRAPPER}} .peeao-wrapper .power_testimonialcarousel  .owl-nav .owl-prev,{{WRAPPER}} .peeao-wrapper .power_testimonialcarousel  .owl-nav .owl-next,{{WRAPPER}} .power_outside_grid_owl_prev, .power_outside_grid_owl_next',
			]
		);
		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'peeao_testimonial_carousel_nav_box_shadow',
				'label'    => __('Box Shadow', 'power-elements'),
				'selector' => '{{WRAPPER}} .peeao-wrapper .power_testimonialcarousel  .owl-nav .owl-prev, {{WRAPPER}} .peeao-wrapper .power_testimonialcarousel  .owl-nav .owl-next, {{WRAPPER}} .power_outside_grid_owl_next,{{WRAPPER}} .power_outside_grid_owl_prev',
			]
		);
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'     => 'peeao_testimonial_carousel_nav_border',
				'label'    => __('Border', 'power-elements'),
				'selector' => '{{WRAPPER}} .peeao-wrapper .power_testimonialcarousel  .owl-nav .owl-prev, {{WRAPPER}} .peeao-wrapper .power_testimonialcarousel  .owl-nav .owl-next, {{WRAPPER}} .power_outside_grid_owl_next,{{WRAPPER}} .power_outside_grid_owl_prev',
			]
		);
		$this->end_controls_tab();

		$this->start_controls_tab(
			'peeao_testimonial_carousel_nav_hover_tab',
			[
				'label' => __('Hover', 'power-elements'),
			]
		);
		$this->add_control(
			'peeao_testimonial_carousel_nav_hover_color',
			[
				'label'     => __('Color', 'power-elements'),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .peeao-wrapper .power_testimonialcarousel  .owl-nav .owl-prev:hover, {{WRAPPER}} .peeao-wrapper .power_testimonialcarousel  .owl-nav .owl-next:hover, {{WRAPPER}} .power_outside_grid_owl_next:hover ,{{WRAPPER}} .power_outside_grid_owl_prev:hover' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name'     => 'peeao_testimonial_carousel_nav_bg_hover_color',
				'label'    => __('Background Color', 'power-elements'),
				'types'    => ['classic', 'gradient'],
				'selector' => '{{WRAPPER}} .peeao-wrapper .power_testimonialcarousel  .owl-nav .owl-prev:hover, {{WRAPPER}} .peeao-wrapper .power_testimonialcarousel  .owl-nav .owl-next:hover, {{WRAPPER}} .power_outside_grid_owl_next:hover,{{WRAPPER}} .power_outside_grid_owl_prev:hover',
			]
		);
		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'peeao_testimonial_carousel_nav_hover_box_shadow',
				'label'    => __('Box Shadow', 'power-elements'),
				'selector' => '{{WRAPPER}} .peeao-wrapper .power_testimonialcarousel  .owl-nav .owl-prev:hover, {{WRAPPER}} .peeao-wrapper .power_testimonialcarousel  .owl-nav .owl-next:hover, {{WRAPPER}} .power_outside_grid_owl_next:hover,{{WRAPPER}} .power_outside_grid_owl_prev:hover',
			]
		);
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'     => 'peeao_testimonial_carousel_nav_hover_border',
				'label'    => __('Border', 'power-elements'),
				'selector' => '{{WRAPPER}} .peeao-wrapper .power_testimonialcarousel  .owl-nav .owl-prev:hover, {{WRAPPER}} .peeao-wrapper .power_testimonialcarousel  .owl-nav .owl-next:hover, {{WRAPPER}} .power_outside_grid_owl_next:hover,{{WRAPPER}} .power_outside_grid_owl_prev:hover',
			]
		);
		$this->end_controls_tab();
		$this->end_controls_tabs();
		$this->add_responsive_control(
			'peeao_testimonial_carousel_nav_radius',
			[
				'label'      => __('Border Radius', 'power-elements'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors'  => [
					'{{WRAPPER}} .peeao-wrapper .power_testimonialcarousel  .owl-nav .owl-prev, {{WRAPPER}} .peeao-wrapper .power_testimonialcarousel  .owl-nav .owl-next' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'peeao_testimonial_carousel_nav_padding',
			[
				'label'      => __('Padding', 'power-elements'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors'  => [
					'{{WRAPPER}} .peeao-wrapper .power_testimonialcarousel  .owl-nav .owl-prev, {{WRAPPER}} .peeao-wrapper .power_testimonialcarousel  .owl-nav .owl-next' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
				],
			]
		);
		$this->end_controls_section();
		/*
			 * DOTS Style
			 */
		$this->start_controls_section(
			'peeao_testimonial_carousel_dots_style_tab',
			[
				'label'     => __('Dots', 'power-elements'),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => [
					'peeao_testimonial_carousel_dots' => 'true',
				],
			]
		);
		$this->add_responsive_control(
			'peeao_testimonial_carousel_dots_spacing',
			[
				'label'   => __('Spacing', 'power-elements'),
				'type'    => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'range'   => [
					'min'  => 0,
					'max'  => 100,
					'step' => 1,
				],
				'default' => [
					'size' => 5,
				],
				'selectors' => [
					'{{WRAPPER}} .power_testimonialcarousel.owl-theme .owl-dots .owl-dot' => 'margin: 0 {{SIZE}}{{UNIT}}',
				],
			]
		);
		$this->start_controls_tabs(
			'peeao_testimonial_carousel_dots_tabs'
		);

		$this->start_controls_tab(
			'peeao_testimonial_carousel_dots_normal_tab',
			[
				'label' => __('Normal', 'power-elements'),
			]
		);
		$this->add_responsive_control(
			'peeao_testimonial_carousel_dots_height',
			[
				'label'   => __('Dot Height', 'power-elements'),
				'type'    => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'range'   => [
					'min'  => 0,
					'max'  => 100,
					'step' => 1,
				],
				'default' => [
					'size' => 7,
				],
				'selectors' => [
					'{{WRAPPER}} .power_testimonialcarousel.owl-theme .owl-dots .owl-dot span' => 'height: {{SIZE}}{{UNIT}}',
				],
			]
		);
		$this->add_responsive_control(
			'peeao_testimonial_carousel_dots_width',
			[
				'label'   => __('Dot Width', 'power-elements'),
				'type'    => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'range'   => [
					'min'  => 0,
					'max'  => 100,
					'step' => 1,
				],
				'default' => [
					'size' => 7,
				],
				'selectors' => [
					'{{WRAPPER}} .power_testimonialcarousel.owl-theme .owl-dots .owl-dot span' => 'width: {{SIZE}}{{UNIT}}',
				],
			]
		);
		$this->add_control(
			'peeao_testimonial_carousel_dots_color',
			[
				'label'     => __('Color', 'power-elements'),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .peeao-wrapper .power_testimonialcarousel.owl-theme .owl-dots .owl-dot span' => 'background: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'peeao_testimonial_carousel_dots_box_shadow',
				'label'    => __('Box Shadow', 'power-elements'),
				'selector' => '{{WRAPPER}} .peeao-wrapper .power_testimonialcarousel.owl-theme .owl-dots .owl-dot',
			]
		);
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'     => 'peeao_testimonial_carousel_dots_border',
				'label'    => __('Border', 'power-elements'),
				'selector' => '{{WRAPPER}} .peeao-wrapper .power_testimonialcarousel.owl-theme .owl-dots .owl-dot',
			]
		);
		$this->add_control(
			'peeao_testimonial_carousel_dots_radius',
			[
				'label'      => __('Border Radius', 'power-elements'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors'  => [
					'{{WRAPPER}} .peeao-wrapper .power_testimonialcarousel.owl-theme .owl-dots .owl-dot span' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_tab();
		$this->start_controls_tab(
			'peeao_testimonial_carousel_dots_active_tab',
			[
				'label' => __('Active', 'power-elements'),
			]
		);
		$this->add_responsive_control(
			'peeao_testimonial_carousel_dots_height_active',
			[
				'label'   => __('Dot Height', 'power-elements'),
				'type'    => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'range'   => [
					'min'  => 0,
					'max'  => 100,
					'step' => 1,
				],
				'default' => [
					'size' => 7,
				],
				'selectors' => [
					'{{WRAPPER}} .power_testimonialcarousel.owl-theme .owl-dots .owl-dot.active span' => 'height: {{SIZE}}{{UNIT}}',
				],
			]
		);
		$this->add_responsive_control(
			'peeao_testimonial_carousel_dots_width_active',
			[
				'label'   => __('Dot Width', 'power-elements'),
				'type'    => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'range'   => [
					'min'  => 0,
					'max'  => 100,
					'step' => 1,
				],
				'default' => [
					'size' => 7,
				],
				'selectors' => [
					'{{WRAPPER}} .power_testimonialcarousel.owl-theme .owl-dots .owl-dot.active span' => 'width: {{SIZE}}{{UNIT}}',
				],
			]
		);
		$this->add_control(
			'peeao_testimonial_carousel_dots_active_color',
			[
				'label'     => __('Color', 'power-elements'),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .peeao-wrapper .power_testimonialcarousel.owl-theme .owl-dots .owl-dot.active span' => 'background: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'peeao_testimonial_carousel_dots_active_box_shadow',
				'label'    => __('Box Shadow', 'power-elements'),
				'selector' => '{{WRAPPER}} .peeao-wrapper .power_testimonialcarousel.owl-theme .owl-dots .owl-dot.active span',
			]
		);
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'     => 'peeao_testimonial_carousel_dots_active_border',
				'label'    => __('Border', 'power-elements'),
				'selector' => '{{WRAPPER}} .peeao-wrapper .power_testimonialcarousel.owl-theme .owl-dots .owl-dot.active span',
			]
		);
		$this->add_control(
			'peeao_testimonial_carousel_dots_active_radius',
			[
				'label'      => __('Border Radius', 'power-elements'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors'  => [
					'{{WRAPPER}} .peeao-wrapper .power_testimonialcarousel.owl-theme .owl-dots .owl-dot.active span' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_tab();

		$this->end_controls_tabs();
		$this->add_responsive_control(
			'peeao_testimonial_carousel_dot_align',
			[
				'label'        => __('Alignment', 'power-elements'),
				'type'         => Controls_Manager::CHOOSE,
				'options'      => [
					'left'    => [
						'title' => __('Left', 'power-elements'),
						'icon'  => 'fa fa-align-left',
					],
					'center'  => [
						'title' => __('Center', 'power-elements'),
						'icon'  => 'fa fa-align-center',
					],
					'flex-end'   => [
						'title' => __('Right', 'power-elements'),
						'icon'  => 'fa fa-align-right',
					],
				],
				'default' => 'center',
				'selectors'  => [
					'{{WRAPPER}} .peeao-wrapper .power_testimonialcarousel.owl-theme .owl-dots' => 'justify-content: {{VALUE}};',
				],
			]
		);
		$this->add_responsive_control(
			'peeao_testimonial_carousel_dot_margin',
			[
				'label'      => __('Margin', 'power-elements'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors'  => [
					'{{WRAPPER}} .peeao-wrapper .power_testimonialcarousel.owl-theme .owl-dots' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();
	}


	/**
	 * Render social widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render()
	{
		$settings = $this->get_settings();


		echo '<div class="peeao-wrapper ' . esc_attr($settings['peeao_testimonial_carousel_nav_style']) . '">';
		if ($settings['peeao_testimonial_carousel_list']) {
			$html = '<div class="owl-carousel owl-theme power_testimonialcarousel" 
				data-owl-carousel=\'{"items": ' . esc_attr($settings['peeao_testimonial_carousel_item']) . ',
					 "margin": ' . esc_attr($settings['peeao_testimonial_carousel_margin']['size']) . ',
					  "padding": ' . esc_attr($settings['peeao_testimonial_carousel_padding']['size']) . ', 
					  "autoplay": ' . esc_attr($settings['peeao_testimonial_carousel_autoplay']) . ', 
					  "responsiveClass": ' . esc_attr($settings['peeao_testimonial_carousel_responsive_class']) . ', 
					  "dots": ' . esc_attr($settings['peeao_testimonial_carousel_dots']) . ', 
					  "nav": ' . esc_attr($settings['peeao_testimonial_carousel_nav']) . ',
					  "responsive":{ "0" :{ 
						  "items": ' . esc_attr($settings['peeao_testimonial_carousel_item_mobile']) . ' }, 
						  "540" :{ "items": ' . esc_attr($settings['peeao_testimonial_carousel_item_mobile']) . ' }, 
						  "860" :{ "items" : ' . esc_attr($settings['peeao_testimonial_carousel_item']) . ' } , 
						  "1000":{ "items" : ' . esc_attr($settings['peeao_testimonial_carousel_item']) . ' }}}\'>';
			foreach ($settings['peeao_testimonial_carousel_list'] as $item) {
				if ($item['peeao_testimonial_carousel_image']['url'] != '') {
					if (in_array($settings['peeao_testimonial_carousel_style'], array('style_4', 'style_5', 'style_6', 'style_7', 'style_9'))) {
						$img = '<div class="power_testimonial_carousel_reviewer_image">
                                        <img src="' . $item['peeao_testimonial_carousel_image']['url'] . '" alt="' . esc_attr($item['name_text']) . '">
                                    </div>';
					} else {
						$img = '<div class="power_testimonial_carousel_reviewer_meta_inner">
                                        <div class="power_testimonial_carousel_reviewer_image">
                                            <img src="' . $item['peeao_testimonial_carousel_image']['url'] . '" alt="' . esc_attr($item['name_text']) . '">
                                        </div>
                                    </div>';
					}
				} else {
					$img = '';
				}

				

				if ($item['peeao_testimonial_carousel_ratting']) {
					$ratting = Partials::get_rating_html($item['peeao_testimonial_carousel_ratting']);
				} else {
					$ratting = '';
				}


				if ($settings['peeao_testimonial_carousel_quote_image']['url'] != '') {
					$quote_image = '<div class="power_testimonial_carousel_quote_image">
								<img src="' . $settings['peeao_testimonial_carousel_quote_image']['url'] . '" >
							</div>';
				} else {
					$quote_image = '';
				}

				$watermark_class = ( $settings['peeao_testimonial_carousel_quote_watermark'] == '1' ) ? 'power_testimonial_carousel_quote_watermark' : '';
				if ($settings['peeao_testimonial_carousel_style'] == 'style_2') {
					$html .= '<div class="item"><div class="type_2 power_testimonial_carousel_item">
                                   ' . $img . '
                                    <div class="power_testimonial_carousel_reviewer_content '.esc_attr($watermark_class).'">
                                        <div class="power_testimonial_carousel_reviewer_details">
                                            <h4 class="power_testimonial_carousel_reviewer_name">' . esc_html($item['name_text']) . '</h4>
                                            <h6 class="power_testimonial_carousel_reviewer_company">' . esc_html($item['address_text']) . '</h6>
                                        </div>
                                        <p class="power_testimonial_carousel_reviewer_text">' . esc_html($item['review_text']) . '</p>
                                      ' . $ratting . '
                                    </div>
                                </div></div>';
				} elseif ($settings['peeao_testimonial_carousel_style'] == 'style_3') {
					$html .= '<div class="item"><div class="type_3 power_testimonial_carousel_item">
                                    <div class="power_testimonial_carousel_reviewer_content '.esc_attr($watermark_class).'">
                                        <div class="power_testimonial_carousel_reviewer_details">
                                            <h4 class="power_testimonial_carousel_reviewer_name">' . esc_html($item['name_text']) . '</h4>
                                            <h6 class="power_testimonial_carousel_reviewer_company">' . esc_html($item['address_text']) . '</h6>
                                        </div>
                                        <p class="power_testimonial_carousel_reviewer_text">' . esc_html($item['review_text']) . '</p>
                                       ' . $ratting . '
                                    </div>
                                    ' . $img . '
                                </div></div>';
				} elseif ($settings['peeao_testimonial_carousel_style'] == 'style_4') {
					$html .= '<div class="item"><div class="type_4 power_testimonial_carousel_item power_testimonial_carousel_reviewer_image_aside">
                                    <div class="power_testimonial_carousel_reviewer_content '.esc_attr($watermark_class).'">
                                         <p class="power_testimonial_carousel_reviewer_text">' . esc_html($item['review_text']) . '</p>
                                        ' . $ratting . '
                                    </div>
                                    <div class="power_testimonial_carousel_reviewer_meta_inner">
                                        ' . $img . '
                                        <div class="power_testimonial_carousel_reviewer_details">
                                            <h4 class="power_testimonial_carousel_reviewer_name">' . esc_html($item['name_text']) . '</h4>
                                            <h6 class="power_testimonial_carousel_reviewer_company">' . esc_html($item['address_text']) . '</h6>
                                        </div>
                                    </div>
                                </div></div>';
				} elseif ($settings['peeao_testimonial_carousel_style'] == 'style_5') {
					$html .= '<div class="item"><div class="type_5 power_testimonial_carousel_item power_testimonial_carousel_reviewer_image_aside">
										<div class="power_testimonial_carousel_reviewer_meta_inner">
											' . $img . '
											<div class="power_testimonial_carousel_reviewer_details">
											<h4 class="power_testimonial_carousel_reviewer_name">' . esc_html($item['name_text']) . '</h4>
											<h6 class="power_testimonial_carousel_reviewer_company">' . esc_html($item['address_text']) . '</h6>
											</div>
										</div>
										<div class="power_testimonial_carousel_reviewer_content '.esc_attr($watermark_class).'">
											<p class="power_testimonial_carousel_reviewer_text">' . esc_html($item['review_text']) . '</p>
										' . $ratting . '
										</div>
									</div>
								</div>';
				} elseif ($settings['peeao_testimonial_carousel_style'] == 'style_6') {
					$html .= '<div class="item"><div class="type_6 power_testimonial_carousel_item power_testimonial_carousel_reviewer_image_aside">
										<div class="power_testimonial_carousel_reviewer_meta_inner">
											' . $img . '
											<div class="power_testimonial_carousel_reviewer_details">
												<div class="power_testimonial_carousel_reviewer_content '.esc_attr($watermark_class).'">
													<h4 class="power_testimonial_carousel_reviewer_name">' . esc_html($item['name_text']) . '</h4>
													<h6 class="power_testimonial_carousel_reviewer_company">' . esc_html($item['address_text']) . '</h6>
													<p class="power_testimonial_carousel_reviewer_text">' . esc_html($item['review_text']) . '</p>
												' . $ratting . '
												</div>
											</div>
										</div>
									</div>
								</div>';
				} elseif ($settings['peeao_testimonial_carousel_style'] == 'style_7') {
					$html .= '<div class="item"><div class="type_7 power_testimonial_carousel_item power_testimonial_carousel_reviewer_image_aside">
										<div class="power_testimonial_carousel_reviewer_content '.esc_attr($watermark_class).'">
											<p class="power_testimonial_carousel_reviewer_text">' . esc_html($item['review_text']) . '</p>
											' . $ratting . '
										</div>
										<div class="power_testimonial_carousel_reviewer_meta_inner">
											' . $img . '
											<div class="power_testimonial_carousel_reviewer_details">
												<h4 class="power_testimonial_carousel_reviewer_name">' . esc_html($item['name_text']) . '</h4>
												<h6 class="power_testimonial_carousel_reviewer_company">' . esc_html($item['address_text']) . '</h6>
											</div>
										</div>
									</div>
								</div>';
				} elseif ($settings['peeao_testimonial_carousel_style'] == 'style_8') {
					$html .= '<div class="item"><div class="type_8 power_testimonial_carousel_item power_testimonial_carousel_reviewer_image_aside">
										<div class="power_testimonial_carousel_reviewer_meta_inner">
											' . $img . '
											<div class="power_testimonial_carousel_reviewer_details">
											<h4 class="power_testimonial_carousel_reviewer_name">' . esc_html($item['name_text']) . '</h4>
											<h6 class="power_testimonial_carousel_reviewer_company">' . esc_html($item['address_text']) . '</h6>
											</div>
										</div>
										<div class="power_testimonial_carousel_reviewer_content '.esc_attr($watermark_class).'">
											<p class="power_testimonial_carousel_reviewer_text">' . esc_html($item['review_text']) . '</p>
										' . $ratting . '
										</div>
									</div>
								</div>';
				} elseif ($settings['peeao_testimonial_carousel_style'] == 'style_9') {
					$html .= '<div class="item"><div class="type_9 power_testimonial_carousel_item power_testimonial_carousel_reviewer_image_aside">
										<div class="power_testimonial_carousel_reviewer_meta_inner">
											' . $img . '
											<div class="power_testimonial_carousel_reviewer_details">
												<div class="power_testimonial_carousel_reviewer_content '.esc_attr($watermark_class).'">
													' . $ratting . '
													<p class="power_testimonial_carousel_reviewer_text">' . esc_html($item['review_text']) . '</p>
													<h4 class="power_testimonial_carousel_reviewer_name">' . esc_html($item['name_text']) . '</h4>
													<h6 class="power_testimonial_carousel_reviewer_company">' . esc_html($item['address_text']) . '</h6>
												</div>
											</div>
										</div>
									</div>
								</div>';
				} elseif ($settings['peeao_testimonial_carousel_style'] == 'style_10') {
					$html .= '<div class="item"><div class="type_10 power_testimonial_carousel_item">
										<div class="power_testimonial_carousel_reviewer_meta_inner">
											' . $quote_image . '
											<div class="power_testimonial_carousel_reviewer_details">
												<div class="power_testimonial_carousel_reviewer_content '.esc_attr($watermark_class).'">
													<p class="power_testimonial_carousel_reviewer_text">' . esc_html($item['review_text']) . '</p>
												</div>
											</div>
										</div>
									</div>
								</div>';
				} else {
					$html .= '<div class="item"><div class="type_1 power_testimonial_carousel_item">
                                    ' . $img . '
                                    <div class="power_testimonial_carousel_reviewer_content '.esc_attr($watermark_class).'">
                                        ' . $ratting . '
                                        <p class="power_testimonial_carousel_reviewer_text">' . esc_html($item['review_text']) . '</p>
                                        <div class="power_testimonial_carousel_reviewer_details">
                                            <h4 class="power_testimonial_carousel_reviewer_name">' . esc_html($item['name_text']) . '</h4>
                                            <h6 class="power_testimonial_carousel_reviewer_company">' . esc_html($item['address_text']) . '</h6>
                                        </div>
                                    </div>
                                </div></div>';
				}
			}
			$html .= '</div>';
			echo $html;
		} else {
			echo esc_html__('Something wrong', 'power-elements');
		}
		echo '</div>';
	}

	/**
	 * Render social widget output in the editor.
	 *
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function _content_template()
	{
	}
}
