<?php

namespace PowerElements;

use PowerElements\Helpers\Partials as Partials;
use PowerElements\Helpers\Utils as Utils;

/**
 * Created by PhpStorm.
 * User: j3sha
 * Date: 6/15/2019
 * Time: 12:41 PM
 */
$archive_year  = get_the_time('Y');
$archive_month = get_the_time('m');
$archive_day   = get_the_time('d');

ob_start();
if ($post_args['peeao_blog_show_read_more'] == 1) { ?>
    <div class="power_blog_button_group <?php echo $post_args['peeao_blog_read_more_position'] == '1' ? 'power_read_more_with_meta' : ''; ?>">
        <a href="<?php echo get_the_permalink() ?>" class="power_blog_button">
            <span class="power_blog_button_value"><?php echo esc_html($post_args['peeao_blog_read_more_text']) ?></span>
        </a>
    </div>
<?php }
$read_more_html = ob_get_clean();

ob_start();
$power_meta_with_read_more = $post_args['peeao_blog_read_more_position'] == '1' ? 'power_meta_with_read_more' : '';
if ($post_args['peeao_blog_show_meta'] == '1') { ?>
    <ul class="power_blog_post_meta <?php echo $power_meta_with_read_more; ?>">
        <?php if ($post_args['peeao_blog_show_author'] == 1 || $post_args['peeao_blog_show_avatar'] == 1) { ?>
            <li>
                <span class="power_blog_author">
                    <?php if ($post_args['peeao_blog_show_avatar'] == 1) {
                        echo get_avatar(get_the_author_meta('ID'), 40);
                    }
                    if ($post_args['peeao_blog_show_author'] == 1) { ?>
                        <a href="<?php echo get_author_posts_url(get_the_author_meta('ID'), get_the_author_meta('nickname')); ?>"><?php echo get_the_author(); ?></a></span>
            <?php } ?>
            </li>
        <?php } ?>
        <?php if ($post_args['peeao_blog_category_position'] == '1') { ?>
            <li>
                <span class="power_blog_category"> <i class="peeao-ios-folder"></i> <?php echo esc_html($post_args['peeao_blog_category_text'], 'power-elements') ?> <?php echo Partials::get_categories_lists(get_the_ID()) ?></span>
            </li>
        <?php } ?>

        <?php if ($post_args['peeao_blog_show_date'] == 1) { ?>

            <?php if ($post_args['peeao_blog_show_date_style'] == 1) { ?>

                <li><span class="power_blog_date"><?php \Elementor\Icons_Manager::render_icon($post_args['peeao_blog_date_icon']); ?><a href="<?php echo get_day_link($archive_year, $archive_month, $archive_day); ?>"><?php echo get_the_date(); ?></a></span>
                </li>

            <?php } else { ?>
                <li>
                    <div class="power_blog_date_advanced">
                        <a href="<?php echo get_day_link($archive_year, $archive_month, $archive_day); ?>">
                            <span class="day"><?php echo get_the_date('d'); ?></span>
                            <span class="month"><?php echo get_the_date('F Y'); ?></span>
                        </a>
                    </div>
                </li>
            <?php } ?>
        <?php } ?>
        <?php if ($post_args['peeao_blog_show_comments'] == 1) { ?>
            <li>
                <span class="power_blog_comments"><?php \Elementor\Icons_Manager::render_icon($post_args['peeao_blog_comment_icon']); ?>
                    <a href="<?php echo get_comments_link(); ?>">
                        <?php if (get_comments_number() > 1) {
                            echo sprintf(__('%d Comments.', 'power-elements'), get_comments_number());
                        } elseif (get_comments_number() == 1) {
                            _e('1 Comment.', 'get_comments_number()');
                        } else {
                            _e('0 Comment.', 'get_comments_number()');
                        } ?>
                    </a>
                </span>
            </li>
        <?php } ?>
    </ul>
<?php
}
$meta_item_html = ob_get_clean();
?>
<div class="col-md-<?php echo esc_attr($post_args['peeao_blog_grid_item']); ?>">
    <div class="item test">
        <article class="power_blog_post">

            <?php if ($post_args['peeao_blog_show_image'] == 1) {
                $post_image_url = wp_get_attachment_image_url(get_post_thumbnail_id(), $post_args['peeao_blog_image_size']);
            ?>
                <div class="power_blog_post_img">
                    <img src="<?php echo esc_url($post_image_url) ?>" alt="<?php echo get_the_title(); ?>">
                </div>
            <?php } ?>
            <div class="power_blog_post_content">
                <div class="power_blog_post_header">
                    <?php if ($post_args['peeao_blog_show_category'] == '1' && $post_args['peeao_blog_category_position'] == '2') { ?>
                        <h4 class="power_blog_post_cat">
                            <?php if ($post_args['peeao_blog_category_text'] != '') : ?><span><?php echo esc_html($post_args['peeao_blog_category_text'], 'power-elements') ?></span><?php endif; ?>
                            <?php echo Partials::get_categories_lists(get_the_ID()); ?>
                        </h4>
                    <?php } ?>
                    <?php if ($post_args['peeao_blog_meta_position'] == '1')
                        echo Utils::kses($meta_item_html);

                    if ($post_args['peeao_blog_show_title'] == 1) { ?>
                        <h3 class="power_blog_post_title"><a href="<?php echo esc_url(get_the_permalink(get_the_ID())) ?>"><?php echo the_title(); ?></a>
                        </h3>
                    <?php } ?>
                </div>

                <?php
                if ($post_args['peeao_blog_meta_position'] == '2')
                    echo Utils::kses($meta_item_html);

                if ($post_args['peeao_blog_show_excerpt'] == 1) { ?>
                    <div class="power_blog_post_intro">
                        <p><?php echo wp_trim_words(get_the_excerpt(), $post_args['peeao_blog_excerpt_length']); ?></p>
                    </div>
                <?php } ?>
                <?php $power_meta_with_read_more = $post_args['peeao_blog_read_more_position'] == '1' ? 'power_meta_with_read_more' : ''; ?>
                <div class="power-blog-meta-readmore  <?php echo $power_meta_with_read_more; ?>">
                    <?php
                    if ($post_args['peeao_blog_meta_position'] == '3')
                        echo Utils::kses($meta_item_html);

                    echo Utils::kses($read_more_html);
                    ?>
                </div>
            </div>
        </article>
    </div>
</div>