<?php
namespace PowerElements;

use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class PowerElements_Instafeed extends Widget_Base {

	public function get_name() { 
		return 'power_elements_instafeed';
	}
	public function get_title() {
		return __( 'Instagram Feed', 'power-elements' );
	}
	public function get_icon() {
		return 'eicon-instagram-nested-gallery';
    }
    public function get_categories() {
		return [ 'power-elements' ];
	}
    protected function _register_controls() {

  		$this->start_controls_section(
  			'peeao_section_instafeed_form',
  			[
  				'label' => __( 'Instagram Feed', 'power-elements' )
  			]
  		);

		$this->add_control(
			'peeao_instafeed_access_token',
			[
				'label' => __( 'Instagram Access Token', 'power-elements' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
			]
		);
		$this->add_control(
			'peeao_instafeed_user_id',
			[
				'label' => __( 'Instagram User Id', 'power-elements' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
			]
		);
		$this->add_control(
			'peeao_instafeed_enable_carousel',
			[
				'label' => esc_html__( 'Enable Carousel?', 'power-elements' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes', 'power-elements' ),
				'label_off' => esc_html__( 'No', 'power-elements' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		$this->add_control(
			'peeao_instafeed_number_of_columns',
			[
				'label' =>esc_html__( 'Number of columns', 'power-elements' ),
				'type' => Controls_Manager::SELECT,
				'default' => '3',
				'options' => [
					'1' =>esc_html__( '1', 'power-elements' ),
					'2' =>esc_html__( '2', 'power-elements' ),
					'3' =>esc_html__( '3', 'power-elements' ),
					'4' =>esc_html__( '4', 'power-elements' ),
					'5' =>esc_html__( '5', 'power-elements' ),
					'6' =>esc_html__( '6', 'power-elements' ),
					'7' =>esc_html__( '7', 'power-elements' ),
					'8' =>esc_html__( '8', 'power-elements' ),
					'9' =>esc_html__( '9', 'power-elements' ),
					'10' =>esc_html__( '10', 'power-elements' ),
					'11' =>esc_html__( '11', 'power-elements' ),
					'12' =>esc_html__( '12', 'power-elements' ),
				],
			]
		);
		
		$this->add_control(
			'peeao_instafeed_limit',
			[
				'label'       => __( 'Limit', 'power-elements' ),
				'type'        => Controls_Manager::TEXT,
				'default'     => __( '12', 'power-elements' ),
				'placeholder' => __( 'Type your number here', 'power-elements' ),
			]
		);
		$this->add_responsive_control(
			'peeao_instafeed_item_padding',
			[
				'label'      => __( 'Gutter', 'power-elements' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .peeao-wrapper #power-instafeed-gallery a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section(); 
	}
	
    protected function render() {

		$settings = $this->get_settings(); 
		extract($settings); ?>

		<div class="peeao-wrapper">
			<?php  if($peeao_instafeed_enable_carousel == 'yes'){ ?>
				<div id="power-instafeed-gallery" 
					data-limit="<?php echo esc_attr($peeao_instafeed_limit);?>" 
					data-gutter="<?php echo esc_attr($peeao_instafeed_item_gutter);?>" 
					data-columns="<?php echo esc_attr($peeao_instafeed_number_of_columns);?>" 
					data-enable_carousel="<?php echo esc_attr($peeao_instafeed_enable_carousel);?>" 
					data-access_token="<?php echo esc_attr($peeao_instafeed_access_token);?>"
					data-user_id="<?php echo esc_attr($peeao_instafeed_user_id);?>"
					class="power-indtafeed-slide owl-carousel power-dot-style2">
				</div>
			<?php }else{ ?>
				<div id="power-instafeed-gallery" 
					data-limit="<?php echo esc_attr($peeao_instafeed_limit);?>" 
					data-gutter="<?php echo esc_attr($peeao_instafeed_item_gutter);?>" 
					data-enable_carousel="<?php echo esc_attr($peeao_instafeed_enable_carousel);?>" 
					data-access_token="<?php echo esc_attr($peeao_instafeed_access_token);?>"
					data-user_id="<?php echo esc_attr($peeao_instafeed_user_id); ?>"
					class="power-instagram-gallery power-instafeed-grid power-instafeed-grid-<?php echo $peeao_instafeed_number_of_columns; ?>">
				</div>
			<?php } ?>
        </div>
        
	<?php }  
}