<?php
	/*
	Plugin Name: Power Elements
	Plugin URI: https://codecanyon.net/item/power-elements-addon-for-elementor-page-builder-wordpress-plugin/25849989
	Description: Power Elements is an elementor supported addons.
	Version: 1.0.2
	Author: wpthemebooster
	Author URI: https://wpthemebooster.com/
	License: GPLv3 or later
    */
    
    if ( ! defined( 'ABSPATH' ) ) {
		exit; // Exit if accessed directly. 
    }
    
    require_once __DIR__ . '/vendor/autoload.php';
    final class PowerElements{

        const version = '1.0.2';
        const api_url = 'http://api.wpthemebooster.com/public/';

        private function __construct() {

            $this->define_constants();
            register_activation_hook( __FILE__, [ $this, 'activate' ] );
            add_action( 'plugins_loaded', [ $this, 'init' ] );
            add_action( 'init', [ $this, 'i18n' ] );

            add_action( 'elementor/elements/categories_registered', [$this, 'widget_categories'] );

        }

        public static function instance() {

            static $instance = false;
			if ( ! $instance ) {
				$instance = new self();
			}
            return $instance;
            
		}
		
		public function i18n() {
			load_plugin_textdomain( 'power-elements', false, basename( dirname( __FILE__ ) ) . '/languages' );	
		}

        public function define_constants(){
            
            define('VERSION', self::version);
			define('POWER_ELEMENTS_VERSION', self::version);
			
            define('MINIMUM_ELEMENTOR_VERSION','2.0.0'); 
			define('MINIMUM_PHP_VERSION','5.6');
			
            define('POWER_ELEMENTS_DIR_URL',plugin_dir_url(__FILE__));
            define('POWER_ELEMENTS_DIR_PATH', plugin_dir_path(__FILE__));

            define('POWER_ELEMENTS_INCLUDES_DIR_PATH', POWER_ELEMENTS_DIR_PATH.'/includes');
            define('POWER_ELEMENTS_ADMIN_DIR_PATH', POWER_ELEMENTS_INCLUDES_DIR_PATH.'/Admin');
            define('POWER_ELEMENTS_WIDGETS_DIR_PATH', POWER_ELEMENTS_DIR_PATH.'/widgets');

            define('POWER_ELEMENTS_WIDGETS_DIR_URL', POWER_ELEMENTS_DIR_URL. '/widgets');
            define('POWER_ELEMENTS_ASSETS_DIR_URL', POWER_ELEMENTS_DIR_URL. '/assets');
            
            define('POWER_ELEMENTS_CSS_DIR_URL', POWER_ELEMENTS_ASSETS_DIR_URL .'/css');
            define('POWER_ELEMENTS_JS_DIR_URL', POWER_ELEMENTS_ASSETS_DIR_URL .'/js');
            define('POWER_ELEMENTS_IMG_DIR_URL', POWER_ELEMENTS_ASSETS_DIR_URL .'/images');

            define('POWER_ELEMENTS_ADMIN_CSS_DIR_URL', POWER_ELEMENTS_CSS_DIR_URL .'/admin');
            define('POWER_ELEMENTS_ADMIN_JS_DIR_URL', POWER_ELEMENTS_JS_DIR_URL .'/admin');
            define('POWER_ELEMENTS_ADMIN_IMG_DIR_URL', POWER_ELEMENTS_IMG_DIR_URL .'/admin');

			define('POWER_ELEMENTS_LAYOUT_CSS_DIR_URL', POWER_ELEMENTS_CSS_DIR_URL . '/layouts');
			define('POWER_ELEMENTS_LAYOUT_JS_DIR_URL', POWER_ELEMENTS_JS_DIR_URL . '/layouts');
			
			define('POWER_ELEMENTS_MENU_DIR_PATH', POWER_ELEMENTS_ADMIN_DIR_PATH . '/Menu');
			define('POWER_ELEMENTS_LAYOUT_DIR_PATH', POWER_ELEMENTS_ADMIN_DIR_PATH . '/Layouts');
			
            define('POWER_ELEMENTS_API_URL', esc_url(self::api_url));
            define('POWER_ELEMENTS_API_SERVER_URL', POWER_ELEMENTS_API_URL . '/power-layouts/');
			define('POWER_ELEMENTS_API_SOURCE', ['power-api']);
			
        }
        
        public function init(){
            if ( ! did_action( 'elementor/loaded' ) ) {
				add_action( 'admin_notices', [ $this, 'admin_notice_missing_main_plugin' ] );
				
				return;
			}
			
			if ( ! version_compare( ELEMENTOR_VERSION, MINIMUM_ELEMENTOR_VERSION, '>=' ) ) {
				add_action( 'admin_notices', [ $this, 'admin_notice_minimum_elementor_version' ] );
				
				return;
			}
			
			if ( version_compare( PHP_VERSION, MINIMUM_PHP_VERSION, '<' ) ) {
				add_action( 'admin_notices', [ $this, 'admin_notice_minimum_php_version' ] );
				
				return;
			}
			
            new PowerElements\Hook\Init;
        }

        public function widget_categories( $elements_manager){
			$elements_manager->add_category(
				'power-elements',
				[
					'title' => __( 'Power Elements', 'power-elements' ),
					'icon' => 'fa fa-plug',
				]
			);
        }
        
        public function activate(){
            $installed = get_option('power_elements_installed');
            if(!$installed){
                update_option( 'power_elements_installed', time() );
            }
            
            update_option( 'power_elements_version', POWER_ELEMENTS_VERSION );
        }
        public function admin_notice_missing_main_plugin() {
			
			if ( isset( $_GET['activate'] ) ) {
				unset( $_GET['activate'] );
			}
			
			$message = sprintf(
				
				esc_html__( '"%1$s" requires "%2$s" to be installed and activated.', 'power-elements' ),
				'<strong>' . esc_html__( 'Power Elements', 'power-elements' ) . '</strong>',
				'<strong>' . esc_html__( 'Elementor', 'power-elements' ) . '</strong>'
			);
			
			printf( '<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message );
			
		}
		
		public function admin_notice_minimum_elementor_version() {
			
			if ( isset( $_GET['activate'] ) ) {
				unset( $_GET['activate'] );
			}
			
			$message = sprintf(
				
				esc_html__( '"%1$s" requires "%2$s" version %3$s or greater.', 'power-elements' ),
				'<strong>' . esc_html__( 'Power Elements', 'power-elements' ) . '</strong>',
				'<strong>' . esc_html__( 'Elementor', 'power-elements' ) . '</strong>',
				MINIMUM_ELEMENTOR_VERSION
			);
			
			printf( '<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message );
			
		}
		
		public function admin_notice_minimum_php_version() {
			
			if ( isset( $_GET['activate'] ) ) {
				unset( $_GET['activate'] );
			}
			
			$message = sprintf(
				
				esc_html__( '"%1$s" requires "%2$s" version %3$s or greater.', 'power-elements' ),
				'<strong>' . esc_html__( 'Power Elements', 'power-elements' ) . '</strong>',
				'<strong>' . esc_html__( 'PHP', 'power-elements' ) . '</strong>',
				MINIMUM_PHP_VERSION
			);
			
			printf( '<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message );
			
		}
    }

    function power_elements(){
        return PowerElements::instance();
    }
	power_elements();