<?php
namespace PowerElements\Override;

use Elementor\Controls_Manager;
use Elementor\Element_Base;
use Elementor\Core\DynamicTags\Dynamic_CSS as DC;
defined( 'ABSPATH' ) || die();

class Css {
    public function __construct() {
        add_action( 'elementor/element/section/_section_responsive/after_section_end', [ __CLASS__, 'add_power_css'] );
        add_action( 'elementor/element/column/_section_responsive/after_section_end', [ __CLASS__, 'add_power_css'] );
        add_action( 'elementor/element/common/_section_responsive/after_section_end', [ __CLASS__, 'add_power_css'] );

        add_action( 'elementor/element/after_add_attributes', [ $this, 'render_attributes' ] );

        add_action( 'elementor/element/parse_css', [ $this, 'add_power_post_css' ], 10, 2 );

    }

	/**
	 * @param $post_css Post
	 * @param $element  Element_Base
	 */
	public function add_power_post_css( $post_css, $element ) {

		if ( $post_css instanceof DC ) {
			return;
		}

		$element_settings = $element->get_settings_for_display();
		
		if ( empty( $element_settings['power_custom_css'] ) ) {
			return;
		}

		$css = trim( $element_settings['power_custom_css'] );

		if ( empty( $css ) ) {
			return;
        }

		$css = str_replace( 'selector', $post_css->get_element_unique_selector( $element ), $css );

		// Add a css comment
		$css = sprintf( '/* Start custom CSS for %s, class: %s */', $element->get_name(), $element->get_unique_selector() ) . $css . '/* End custom CSS */';

		$post_css->get_stylesheet()->add_raw_css( $css );
	}

    public static function add_power_css( Element_Base $element ) {
        $element->start_controls_section(
            '_section_power_css',
            [
                'label' => esc_html__( 'Power CSS', 'power-elements' ),
                'tab' => Controls_Manager::TAB_ADVANCED,
            ]
        );
        $element->add_control(
			'power_custom_css_title',
			[
				'raw' => __( 'Add your own custom CSS here', 'power-elements' ),
				'type' => Controls_Manager::RAW_HTML,
			]
        );
        $element->add_control(
			'power_custom_css',
			[
				'type' => Controls_Manager::CODE,
				'label' => __( 'Custom CSS', 'power-elements' ),
				'language' => 'css',
				'render_type' => 'ui',
				'show_label' => false,
				'separator' => 'none',
			]
        );
        $element->add_control(
			'power_custom_title',
			[
				'label' => __( 'Custom HTML', 'power-elements' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Default description', 'power-elements' ),
			]
		);
        $element->add_control(
			'power_custom_css_description',
			[
				'raw' => __( 'Use "selector" to target wrapper element. Examples:<br>selector {color: red;} // For main element<br>selector .child-element {margin: 10px;} // For child element<br>.my-class {text-align: center;} // Or use any custom selector', 'power-elements' ),
				'type' => Controls_Manager::RAW_HTML,
				'content_classes' => 'power-descriptor',
			]
        );
        $element->end_controls_section();
    }

    /**
	 * @param $element Element_Base
	 */
	public function render_attributes( Element_Base $element ) {
        $settings = $element->get_settings_for_display();
		extract($settings);

    }
}
