<?php

namespace PowerElements\Admin\WidgetsMap;

use \PowerElements\Helpers\Utils as Utils;

class Init
{

    function __construct()
    {
        add_action('elementor/widgets/widgets_registered', [$this, 'register_widget'], 10, 1);
    }

    public function register_widget($widgets_manager)
    {
        $default_widgets = self::default_widgets();
        $active_widgets = self::active_widgets();

        foreach ($active_widgets as $widget) {
            if (in_array($widget, $default_widgets)) {
                $class_name = 'PowerElements\PowerElements_' . Utils::mk_class($widget);
                include POWER_ELEMENTS_WIDGETS_DIR_PATH . '/' . $widget . '.php';
                if (class_exists($class_name)) {
                    $widgets_manager->register_widget_type(new $class_name());
                }
            }
        }
    }

    public static function widgets_map()
    {
        return [
            'accordion' => [
                'demo' => 'http://wpthemebooster.com/plugins/power-elements/accordion',
                'title' => __('Accordion', 'power-elements'),
                'icon' => 'eicon-accordion',
            ],
            'button' => [
                'demo' => 'http://wpthemebooster.com/plugins/power-elements/button',
                'title' => __('Button', 'power-elements'),
                'icon' => 'eicon-button',
            ],
            'dual-button' => [
                'demo' => '',
                'title' => __('Dual Button', 'power-elements'),
                'icon' => 'eicon-button',
            ],
            'contact-info' => [
                'demo' => 'http://wpthemebooster.com/plugins/power-elements/contact-info',
                'title' => __('Contact Info', 'power-elements'),
                'icon' => 'eicon-text',
            ],
            'faq' => [
                'demo' => 'http://wpthemebooster.com/plugins/power-elements/faq',
                'title' => __('Faq', 'power-elements'),
                'icon' => 'eicon-accordion',
            ],
            'heading' => [
                'demo' => 'http://wpthemebooster.com/plugins/power-elements/heading',
                'title' => __('Heading', 'power-elements'),
                'icon' => 'eicon-t-letter',
            ],
            'funfact' => [
                'demo' => 'http://wpthemebooster.com/plugins/power-elements/funfact',
                'title' => __('Funfact', 'power-elements'),
                'icon' => 'eicon-nerd-chuckle',
            ],
            'icon-box' => [
                'demo' => 'http://wpthemebooster.com/plugins/power-elements/icon-box',
                'title' => __('Icon Box', 'power-elements'),
                'icon' => 'eicon-icon-box',
            ],
            'image-box' => [
                'demo' => 'http://wpthemebooster.com/plugins/power-elements/icon-box',
                'title' => __('Image Box', 'power-elements'),
                'icon' => 'eicon-icon-box',
            ],
            'price-table' => [
                'demo' => 'http://wpthemebooster.com/plugins/power-elements/price-table',
                'title' => __('Price Table', 'power-elements'),
                'icon' => 'eicon-price-table',
            ],
            'circle-progressbar' => [
                'demo' => 'http://wpthemebooster.com/plugins/power-elements/circle-progressbar',
                'title' => __('Circle Progressbar', 'power-elements'),
                'icon' => 'eicon-counter-circle',
            ],
            'progressbar' => [
                'demo' => 'http://wpthemebooster.com/plugins/power-elements/progressbar',
                'title' => __('Progressbar', 'power-elements'),
                'icon' => 'eicon-skill-bar',
            ],
            'blog-carousel' => [
                'demo' => 'http://wpthemebooster.com/plugins/power-elements/blog-carousel',
                'title' => __('Blog Carousel', 'power-elements'),
                'icon' => 'eicon-posts-carousel',
            ],
            'blog-posts' => [
                'demo' => 'http://wpthemebooster.com/plugins/power-elements/blog-posts',
                'title' => __('Blog Posts', 'power-elements'),
                'icon' => 'eicon-posts-grid',
            ],
            'testimonial' => [
                'demo' => 'http://wpthemebooster.com/plugins/power-elements/testimonial',
                'title' => __('Testimonial', 'power-elements'), 
                'icon' => 'eicon-testimonial',
            ],
            'testimonial-carousel' => [
                'demo' => 'http://wpthemebooster.com/plugins/power-elements/testimonial-carousel',
                'title' => __('Testimonial Carousel', 'power-elements'),
                'icon' => 'eicon-testimonial',
            ],
            'team' => [
                'demo' => 'http://wpthemebooster.com/plugins/power-elements/testimonial',
                'title' => __('Team', 'power-elements'),
                'icon' => 'eicon-lock-user',
            ],
            'team-carousel' => [
                'demo' => 'http://wpthemebooster.com/plugins/power-elements/team-carousel',
                'title' => __('Team Carousel', 'power-elements'),
                'icon' => 'eicon-lock-user',
            ],
            'logo' => [
                'demo' => '',
                'title' => __('Logo', 'power-elements'),
                'icon' => 'eicon-logo',
            ],
            'nav-menu' => [
                'demo' => '',
                'title' => __('Nav Menu', 'power-elements'),
                'icon' => 'eicon-nav-menu',
            ],
            'portfolio-filter' => [
                'demo' => 'http://wpthemebooster.com/plugins/power-elements/portfolio-filter',
                'title' => __('Portfolio Filter', 'power-elements'),
                'icon' => 'eicon-posts-justified',
            ],
            'portfolio-carousel' => [
                'demo' => 'http://wpthemebooster.com/plugins/power-elements/portfolio-carousel',
                'title' => __('Portfolio Carousel', 'power-elements'),
                'icon' => 'eicon-posts-carousel',
            ],
            'tabs' => [
                'demo' => 'http://wpthemebooster.com/plugins/power-elements/tabs',
                'title' => __('Tabs', 'power-elements'),
                'icon' => 'eicon-tabs',
            ],
            'social' => [
                'demo' => 'http://wpthemebooster.com/plugins/power-elements/social',
                'title' => __('Social', 'power-elements'),
                'icon' => 'eicon-social-icons',
            ],
            'social-share' => [
                'demo' => '',
                'title' => __('Social Share', 'power-elements'),
                'icon' => 'eicon-social-icons',
            ],
            'carousel' => [
                'demo' => '',
                'title' => __('Carousel', 'power-elements'),
                'icon' => 'eicon-carousel',
            ],
            'wpcf7' => [
                'demo' => '',
                'title' => __('Contact Form 7', 'power-elements'),
                'icon' => 'eicon-form-horizontal',
            ],
            'easy-forms' => [
                'demo' => '',
                'title' => __('Easy Forms', 'power-elements'),
                'icon' => 'eicon-form-horizontal',
            ],
            'instafeed' => [
                'demo' => '',
                'title' => __('Instagram Feed', 'power-elements'),
                'icon' => 'eicon-instagram-nested-gallery',
            ],
            'slider' => [
                'demo' => '',
                'title' => __('Slider', 'power-elements'),
                'icon' => 'eicon-media-carousel',
            ],
            'video' => [
                'demo' => '',
                'title' => __('Video', 'power-elements'),
                'icon' => 'eicon-youtube',
            ],
            'demo-gallery' => [
                'demo' => '',
                'title' => __('Demo Gallery', 'power-elements'),
                'icon' => 'eicon-button',
            ],
        ];
    }

    public static function form_builder_widgets_map()
    {
        return [
            'submit' => [
                'demo' => '',
                'title' => __('Submit', 'power-elements'),
                'icon' => 'eicon-button',
            ],
            'email' => [
                'demo' => '',
                'title' => __('Email', 'power-elements'),
                'icon' => 'eicon-button',
            ],
            'text' => [
                'demo' => '',
                'title' => __('Text', 'power-elements'),
                'icon' => 'eicon-button',
            ],
        ];
    }

    public static function default_form_builder_widgets()
    {
        $map = self::form_builder_widgets_map();
        $default_form_builder_widgets = [];
        foreach ($map as $key => $value) {
            $default_form_builder_widgets[] = $key;
        }
        return $default_form_builder_widgets;
    }
    
    public static function default_widgets()
    {
        $map = self::widgets_map();
        $dynamic_widgets = [];
        foreach ($map as $key => $value) {
            $dynamic_widgets[] = $key;
        }
        return $dynamic_widgets;
    }

    public static function active_widgets($default = [])
    {
        return Utils::get_option('power_elements_options', 'widget_list', $default);
    }
}
